Public Class Form1

    Public m_pCustomVideoRenderer As UInt32

    Public m_pCustomChannelWindow As UInt32

    Public m_pCustomOverlayWindow As UInt32

    Public m_pCustomOverlayWindowDynamic As UInt32

    Public m_hVideoDevice As UInt32

    Public m_hAudioDevice As UInt32

    Public m_pVideoBufferCB As LibraryWrapper.EXPORTS.PF_BUFFER_CALLBACK = Nothing

    Public m_pAudioBufferCB As LibraryWrapper.EXPORTS.PF_BUFFER_CALLBACK = Nothing

    Public Function on_process_video_buffer(ByVal dSampleTime As Double, ByVal pBuffer As UInt32, ByVal nBufferLen As UInt32, ByVal bIsKeyFrame As UInt32, ByVal pUserData As UInt32) As UInt32

        Dim hVideoDev As UInt32 = m_hVideoDevice

        LibraryWrapper.EXPORTS.CVRSDK_UPDATE_VIDEO_BUFFER(m_pCustomChannelWindow, pBuffer, &H32595559, 640, 480, 1)

        Return 0

    End Function

    Public Function on_process_audio_buffer(ByVal dSampleTime As Double, ByVal pBuffer As UInt32, ByVal nBufferLen As UInt32, ByVal bIsKeyFrame As UInt32, ByVal pUserData As UInt32) As UInt32

        Dim hAudioDev As UInt32 = m_hAudioDevice

        Return 0

    End Function

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Dim BorderSize As System.Drawing.Size = Me.Size - Me.ClientSize

        Me.Width = BorderSize.Width + 640

        Me.Height = BorderSize.Height + 480

        ' CREATE CUSTOM VIDEO RENDERER
        '
        m_pCustomVideoRenderer = LibraryWrapper.EXPORTS.CVRSDK_CREATE()

        If m_pCustomVideoRenderer Then

            m_pCustomChannelWindow = LibraryWrapper.EXPORTS.CVRSDK_INSERT_CHANNEL_WINDOW(m_pCustomVideoRenderer, Me.Handle)

            'If m_pCustomChannelWindow Then

            '   LibraryWrapper.EXPORTS.CVRSDK_MOVE_CHANNEL_WINDOW(m_pCustomChannelWindow, 0, 0, 640, 480)

            '   LibraryWrapper.EXPORTS.CVRSDK_SHOW_CHANNEL_WINDOW(m_pCustomChannelWindow, True)

            'End If

        End If

        ' CREATE VIDEO/AUDIO DEVICE
        '
        m_hVideoDevice = 4294967295 '4294967295 = &HFFFFFFFF

        m_hAudioDevice = 4294967295 '4294967295 = &HFFFFFFFF

        m_pVideoBufferCB = New LibraryWrapper.EXPORTS.PF_BUFFER_CALLBACK(AddressOf on_process_video_buffer)

        m_pAudioBufferCB = New LibraryWrapper.EXPORTS.PF_BUFFER_CALLBACK(AddressOf on_process_audio_buffer)

        m_hVideoDevice = LibraryWrapper.EXPORTS.AMESDK_CREATE("TW6802 PCI", 0, 0, 0, m_pVideoBufferCB, 0)

        m_hAudioDevice = LibraryWrapper.EXPORTS.AMESDK_CREATE("TW6802 PCI, Analog WaveIn", 0, 0, 0, m_pAudioBufferCB, 0)

        If (m_hVideoDevice And &H80000000) = &H80000000 Then m_hVideoDevice = 4294967295 '4294967295 = &HFFFFFFFF

        If (m_hAudioDevice And &H80000000) = &H80000000 Then m_hAudioDevice = 4294967295 '4294967295 = &HFFFFFFFF

        LibraryWrapper.EXPORTS.AMESDK_SET_STANDARD(m_hVideoDevice, &H1) 'NTSC = &H00000001 / PAL = &H00000010

        LibraryWrapper.EXPORTS.AMESDK_SET_FORMAT(m_hVideoDevice, &H32595559, 640, 480, 12, 29.97) 'YUY2= &H32595559

        LibraryWrapper.EXPORTS.AMESDK_SET_FORMAT(m_hAudioDevice, 1, 8, 8000)

        LibraryWrapper.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoDevice, 209, &H1)

        LibraryWrapper.EXPORTS.AMESDK_RUN(m_hVideoDevice)

        LibraryWrapper.EXPORTS.AMESDK_RUN(m_hAudioDevice)

        ' DRAW STATIC OVERLAY BUFFER
        '
        Dim hMemoryDC As Int32

        m_pCustomOverlayWindow = LibraryWrapper.EXPORTS.CVRSDK_CREATE_OVERLAY_BUFFER(m_pCustomChannelWindow, 330, 30)

        m_pCustomOverlayWindowDynamic = LibraryWrapper.EXPORTS.CVRSDK_CREATE_OVERLAY_BUFFER(m_pCustomChannelWindow, 330, 60)

        If LibraryWrapper.EXPORTS.CVRSDK_LOCK_OVERLAY_BUFFER(m_pCustomChannelWindow, m_pCustomOverlayWindow, hMemoryDC) Then

            Dim system_time As DateTime = DateTime.Now

            Dim system_graphics As Graphics = Graphics.FromHdcInternal(hMemoryDC)

            Dim draw_font_family As New FontFamily("Arial")

            Dim draw_brush_white As New SolidBrush(Color.White)

            Dim draw_color_blue As Color = Color.FromArgb(24, 0, 128, 192)

            Dim draw_path As New System.Drawing.Drawing2D.GraphicsPath

            Dim draw_string = "http://www.yuan.com.tw"

            system_graphics.SmoothingMode = Drawing2D.SmoothingMode.AntiAlias

            system_graphics.InterpolationMode = Drawing2D.InterpolationMode.HighQualityBicubic

            draw_path.AddString(draw_string, draw_font_family, FontStyle.Regular, 24, New Point(0, 0), Nothing)

            Dim i As UInt32 = 0

            For i = 0 To 8

                Dim draw_pen As New Pen(draw_color_blue, i + 1.0)

                draw_pen.LineJoin = Drawing2D.LineJoin.Round

                system_graphics.DrawPath(draw_pen, draw_path)

            Next

            system_graphics.FillPath(draw_brush_white, draw_path)

            system_graphics.Dispose()

            LibraryWrapper.EXPORTS.CVRSDK_UNLOCK_OVERLAY_BUFFER(m_pCustomChannelWindow, m_pCustomOverlayWindow, hMemoryDC)

            LibraryWrapper.EXPORTS.CVRSDK_SHOW_OVERLAY_BUFFER(m_pCustomChannelWindow, m_pCustomOverlayWindow, 1, 0, 420)

        End If

        Timer_OSD.Interval = 1

    End Sub

    Private Sub Form1_Closed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

        LibraryWrapper.EXPORTS.AMESDK_STOP(m_hVideoDevice)

        LibraryWrapper.EXPORTS.AMESDK_STOP(m_hAudioDevice)

        If (m_hVideoDevice And &H80000000) = &H0 Then LibraryWrapper.EXPORTS.AMESDK_DESTROY(m_hVideoDevice)

        If (m_hAudioDevice And &H80000000) = &H0 Then LibraryWrapper.EXPORTS.AMESDK_DESTROY(m_hAudioDevice)

        m_hVideoDevice = 4294967295 '4294967295 = &HFFFFFFFF

        m_hAudioDevice = 4294967295 '4294967295 = &HFFFFFFFF

        If m_pCustomVideoRenderer Then

            LibraryWrapper.EXPORTS.CVRSDK_DESTROY(m_pCustomVideoRenderer)

        End If

    End Sub

    Private Sub Timer_OSD_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer_OSD.Tick

        ' UPDATE TIMER'S INTERVAL
        '
        Timer_OSD.Interval = 1000

        ' DRAW DYNAMIC OVERLAY BUFFER
        '
        Dim hMemoryDC As Int32

        If LibraryWrapper.EXPORTS.CVRSDK_LOCK_OVERLAY_BUFFER(m_pCustomChannelWindow, m_pCustomOverlayWindowDynamic, hMemoryDC) Then

            Dim system_time As DateTime = DateTime.Now

            Dim system_graphics As Graphics = Graphics.FromHdcInternal(hMemoryDC)

            Dim draw_font As New Font("Terminal", 32, FontStyle.Bold)

            Dim draw_brush_white As New SolidBrush(Color.White)

            Dim draw_brush_black As New SolidBrush(Color.Black)

            Dim draw_string = "CH00 " & (system_time.Hour).ToString("D2") & ":" & (system_time.Minute).ToString("D2") & ":" & (system_time.Second).ToString("D2")

            system_graphics.SmoothingMode = Drawing2D.SmoothingMode.HighSpeed

            system_graphics.InterpolationMode = Drawing2D.InterpolationMode.Low

            system_graphics.DrawString(draw_string, draw_font, draw_brush_black, 0, 1)

            system_graphics.DrawString(draw_string, draw_font, draw_brush_black, 1, 0)

            system_graphics.DrawString(draw_string, draw_font, draw_brush_black, 2, 1)

            system_graphics.DrawString(draw_string, draw_font, draw_brush_black, 1, 2)

            system_graphics.DrawString(draw_string, draw_font, draw_brush_white, 1, 1)

            system_graphics.Dispose()

            LibraryWrapper.EXPORTS.CVRSDK_UNLOCK_OVERLAY_BUFFER(m_pCustomChannelWindow, m_pCustomOverlayWindowDynamic, hMemoryDC)

            LibraryWrapper.EXPORTS.CVRSDK_SHOW_OVERLAY_BUFFER(m_pCustomChannelWindow, m_pCustomOverlayWindowDynamic, 1, 0, 0)

        End If

    End Sub

    Protected Overrides Sub WndProc(ByRef m As System.Windows.Forms.Message)

        If m.Msg = &H14 Then '&H00000014 = WM_ERASEBKGND

            Return

        End If

        MyBase.WndProc(m)

    End Sub

End Class
