#define _QCAP_LABVIEW_IMPORT
typedef int                 BOOL;
#define FALSE 0
#define TRUE 1
typedef int INT;
#include <QDebug>
#include <QDesktopWidget>
#include "channelwindow.h"
#include "ui_channelwindow.h"
#include "setupdlg.h"
#include "audioinputdlg.h"
#include "videoinputdlg.h"
#include "videoqualitydlg.h"
#include "filerecorddlg.h"
#include "sharerecorddlg.h"

#include "ui_setupdlg.h"

#include "QCAP.H"

ChannelWindow*	m_pChannelWindow = NULL;

QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    ULONG i = (ULONG)(pUserData);

    switch (i) {
    case 0:
        m_pChannelWindow->m_setupdlg->ui->m_info1->setText(QString("ch1 info...(signal removed)"));
        break;
    case 1:
        m_pChannelWindow->m_setupdlg->ui->m_info2->setText(QString("ch2 info...(signal removed)"));
        break;
    case 2:
        m_pChannelWindow->m_setupdlg->ui->m_info3->setText(QString("ch3 info...(signal removed)"));
        break;
    case 3:
        m_pChannelWindow->m_setupdlg->ui->m_info4->setText(QString("ch4 info...(signal removed)"));
        break;
    default:
        break;
    }

    return QCAP_RT_OK;
}

QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    ULONG i = (ULONG)(pUserData);

    switch (i) {
    case 0:
        m_pChannelWindow->m_setupdlg->ui->m_info1->setText(QString("ch1 info...(no signal detected)"));
        break;
    case 1:
        m_pChannelWindow->m_setupdlg->ui->m_info2->setText(QString("ch2 info...(no signal detected)"));
        break;
    case 2:
        m_pChannelWindow->m_setupdlg->ui->m_info3->setText(QString("ch3 info...(no signal detected)"));
        break;
    case 3:
        m_pChannelWindow->m_setupdlg->ui->m_info4->setText(QString("ch4 info...(no signal detected)"));
        break;
    default:
        break;
    }

    return QCAP_RT_OK;
}

QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
    ULONG i = (ULONG)(pUserData);

    qDebug("format changed Detected (ch%d) \n", i+1);

    CHAR strVideoInput[ MAX_PATH ] = { 0 };

    CHAR strAudioInput[ MAX_PATH ] = { 0 };

    CHAR strFrameType[ MAX_PATH ] = { 0 };

    m_pChannelWindow->m_nVideoWidth[ i ] = nVideoWidth;

    m_pChannelWindow->m_nVideoHeight[ i ] = nVideoHeight;

    m_pChannelWindow->m_bVideoIsInterleaved[ i ] = bVideoIsInterleaved;

    m_pChannelWindow->m_dVideoFrameRate[ i ] = dVideoFrameRate;

    m_pChannelWindow->m_nAudioChannels[ i ] = nAudioChannels;

    m_pChannelWindow->m_nAudioBitsPerSample[ i ] = nAudioBitsPerSample;

    m_pChannelWindow->m_nAudioSampleFrequency[ i ] = nAudioSampleFrequency;

    m_pChannelWindow->m_nVideoInput[ i ] = nVideoInput;

    m_pChannelWindow->m_nAudioInput[ i ] = nAudioInput;

    UINT nVH = 0;

    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); }

    if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); }

    if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" );}

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" );}

    if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" );}

    if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" );}

    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" );}

    if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" );}

    if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED_AUDIO" );}

    if ( nAudioInput == 1 ) { sprintf( strAudioInput, "LINE_IN" );}

    if ( nAudioInput == 2 ) { sprintf( strAudioInput, "SOUNDCARD_MICROPHONE" );}

    if ( nAudioInput == 3 ) { sprintf( strAudioInput, "SOUNDCARD_LINE_IN" );}

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " ); }

    QString str_info;

    str_info.sprintf("INFO : %d x %d%s @%2.3f FPS , %d CH x %d BITS x %d HZ ,  VIDEO INPUT : %s ,  AUDIO INPUT : %s"

                                                            , nVideoWidth, nVH, strFrameType, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample

                                                            , nAudioSampleFrequency, strVideoInput, strAudioInput);

    switch (i) {
    case 0:
        m_pChannelWindow->m_setupdlg->ui->m_info1->setText(str_info);
        break;
    case 1:
        m_pChannelWindow->m_setupdlg->ui->m_info2->setText(str_info);
        break;
    case 2:
        m_pChannelWindow->m_setupdlg->ui->m_info3->setText(str_info);
        break;
    case 3:
        m_pChannelWindow->m_setupdlg->ui->m_info4->setText(str_info);
        break;
    default:
        break;
    }

    return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    ULONG i = (ULONG)pUserData;

    if( m_pChannelWindow->m_bIsShareRecord && pFrameBuffer && m_pChannelWindow->m_bShareRecordCH[ i ] )
    {
        QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, QCAP_COLORSPACE_TYEP_YUY2, m_pChannelWindow->m_nVideoWidth[ i ], m_pChannelWindow->m_nVideoHeight[ i ], pFrameBuffer, nFrameBufferLen );
    }

    return QCAP_RT_OK;
}

QRETURN on_process_preview_audio_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    ULONG i = (ULONG)pUserData;

    if( m_pChannelWindow->m_bIsShareRecord && pFrameBuffer && m_pChannelWindow->m_bShareRecordCH[ i ] )
    {
        QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen );
    }

    return QCAP_RT_OK;
}

ChannelWindow::ChannelWindow(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ChannelWindow)
{
    ui->setupUi(this);

    m_pChannelWindow = this;

    this->setWindowTitle("SC510 N1");

    this->setWindowFlags(Qt::FramelessWindowHint);

    this->resize(960,540);

    ui->PreviewWindow1->move(0,0);

    ui->PreviewWindow2->move(this->width()/2,0);

    ui->PreviewWindow3->move(0,this->height()/2);

    ui->PreviewWindow4->move(this->width()/2,this->height()/2);

    ui->PreviewWindow1->resize(this->width()/2,this->height()/2);

    ui->PreviewWindow2->resize(this->width()/2,this->height()/2);

    ui->PreviewWindow3->resize(this->width()/2,this->height()/2);

    ui->PreviewWindow4->resize(this->width()/2,this->height()/2);

    ui->PreviewWindow1->setLineWidth(0);

    ui->PreviewWindow2->setLineWidth(0);

    ui->PreviewWindow3->setLineWidth(0);

    ui->PreviewWindow4->setLineWidth(0);

    ui->CloneWindow1->move(this->width()/2-160,this->height()/2-120);

    ui->CloneWindow2->move(this->width()-160,this->height()/2-120);

    ui->CloneWindow3->move((this->width()/2)-160,this->height()-120);

    ui->CloneWindow4->move(this->width()-160,this->height()-120);

    ui->CloneWindow1->resize(160,120);

    ui->CloneWindow2->resize(160,120);

    ui->CloneWindow3->resize(160,120);

    ui->CloneWindow4->resize(160,120);

    ui->CloneWindow1->setLineWidth(0);

    ui->CloneWindow2->setLineWidth(0);

    ui->CloneWindow3->setLineWidth(0);

    ui->CloneWindow4->setLineWidth(0);

    ui->CloneWindow1->close();

    ui->CloneWindow2->close();

    ui->CloneWindow3->close();

    ui->CloneWindow4->close();

    path = QCoreApplication::applicationDirPath();

    CoInitialize( NULL );

    //CONNET SIGNAL & SLOT

    m_setupdlg = new SetUpDlg(this);

    m_setupdlg->show();

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_VideoInput()), this, SLOT(SetUpDialogSlot_VideoInput()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_AudioInput()), this, SLOT(SetUpDialogSlot_AudioInput()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_Snapshot_BMP()), this, SLOT(SetUpDialogSlot_Snapshot_BMP()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_Snapshot_JPG()), this, SLOT(SetUpDialogSlot_Snapshot_JPG()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_VideoQuality()), this, SLOT(SetUpDialogSlot_VideoQuality()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_DEINTERLACE( int )), this, SLOT(SetUpDialogSlot_DEINTERLACE( int )));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_CLONE( int )), this, SLOT(SetUpDialogSlot_CLONE( int )));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_DestroyAP()), this, SLOT(SetUpDialogSlot_DestroyAP()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_FileRecord()), this, SLOT(SetUpDialogSlot_FileRecord()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_ShareRecord()), this, SLOT(SetUpDialogSlot_ShareRecord()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_DisplayWindow()), this, SLOT(SetUpDialogSlot_DisplayWindow()));

    //INITIALIZE MEMBER VARIABLES

    for(ULONG i = 0 ; i < 4 ; i++ )
    {
        m_hVideoDevice[ i ] = NULL;

        m_hCloneCapDev[ i ] = NULL;

        m_nVideoWidth[ i ] = 0;

        m_nVideoHeight[ i ] = 0;

        m_bVideoIsInterleaved[ i ] = 0;

        m_dVideoFrameRate[ i ] = 0;

        m_nAudioChannels[ i ] = 0;

        m_nAudioBitsPerSample[ i ] = 0;

        m_nAudioSampleFrequency[ i ] = 0;

        m_nVideoInput[ i ] = QCAP_INPUT_TYPE_AUTO;

        m_nAudioInput[ i ] = QCAP_INPUT_TYPE_EMBEDDED_AUDIO;

        m_bShareRecordCH[ i ] = FALSE;
    }

    m_bFullScreen = FALSE;

    m_bIsShareRecord = FALSE;

    m_nChannelWindow = 4;

    HwInitialize();
}

void ChannelWindow::HwInitialize()
{
    //CREATE CAPTURE DEVICE

    QCAP_CREATE( "SA7160 PCI", 0, (HWND)ui->PreviewWindow1->winId(), &m_hVideoDevice[0], TRUE);

    QCAP_CREATE( "SA7160 PCI", 1, (HWND)ui->PreviewWindow2->winId(), &m_hVideoDevice[1], TRUE);

    QCAP_CREATE( "SA7160 PCI", 2, (HWND)ui->PreviewWindow3->winId(), &m_hVideoDevice[2], TRUE);

    QCAP_CREATE( "SA7160 PCI", 3, (HWND)ui->PreviewWindow4->winId(), &m_hVideoDevice[3], TRUE);

    for( ULONG i = 0 ; i < 4 ; i++ )
    {
        QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice[ i ], on_process_no_signal_detected, (PVOID)i );

        QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice[ i ], on_process_signal_removed, (PVOID)i );

        QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice[ i ], on_process_format_changed, (PVOID)i );

        QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], on_video_preview_callback, (PVOID)i );

        QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], on_process_preview_audio_buffer, (PVOID)i );

        QCAP_SET_VIDEO_INPUT( m_hVideoDevice[ i ], QCAP_INPUT_TYPE_AUTO );

        QCAP_SET_AUDIO_INPUT( m_hVideoDevice[ i ], QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );

        QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[ i ], 1 );

        QCAP_RUN( m_hVideoDevice[ i ] );
    }

    QCAP_SET_OSD_TEXT(m_hVideoDevice[ 0 ], 0, 50, 50, 0, 0, "CH01", "Arial", QCAP_FONT_STYLE_BOLD, 100, 0xFFFF0000, 0xFFFFFFFF, 128, 0, 0, QCAP_SEQUENCE_STYLE_FOREMOST);

    QCAP_SET_OSD_TEXT(m_hVideoDevice[ 1 ], 0, 50, 50, 0, 0, "CH02", "Arial", QCAP_FONT_STYLE_BOLD, 100, 0xFFFF0000, 0xFFFFFFFF, 128, 0, 0, QCAP_SEQUENCE_STYLE_FOREMOST);

    QCAP_SET_OSD_TEXT(m_hVideoDevice[ 2 ], 0, 50, 50, 0, 0, "CH03", "Arial", QCAP_FONT_STYLE_BOLD, 100, 0xFFFF0000, 0xFFFFFFFF, 128, 0, 0, QCAP_SEQUENCE_STYLE_FOREMOST);

    QCAP_SET_OSD_TEXT(m_hVideoDevice[ 3 ], 0, 50, 50, 0, 0, "CH04", "Arial", QCAP_FONT_STYLE_BOLD, 100, 0xFFFF0000, 0xFFFFFFFF, 128, 0, 0, QCAP_SEQUENCE_STYLE_FOREMOST);
}

void ChannelWindow::HwUninitialize()
{
    //DESTROY CAPTURE DEVICE

    for( ULONG i = 0 ; i < 4 ; i++ )
    {
        if( m_hCloneCapDev[ i ] != 0 )
        {
            QCAP_STOP( m_hCloneCapDev[ i ] );

            QCAP_DESTROY( m_hCloneCapDev[ i ] );

            m_hCloneCapDev[ i ] = NULL;
        }

        if( m_hVideoDevice[ i ] ) {

            QCAP_STOP( m_hVideoDevice[ i ] );

            QCAP_DESTROY( m_hVideoDevice[ i ] );

            m_hVideoDevice[ i ] = NULL;
        }
    }

    CoUninitialize();
}

ChannelWindow::~ChannelWindow()
{
    delete ui;
}

void ChannelWindow::SetUpDialogSlot_VideoInput()
{
    VideoInputDlg video_input(this);

    video_input.exec();
}

void ChannelWindow::SetUpDialogSlot_AudioInput()
{
    AudioInputDlg audio_input(this);

    audio_input.exec();
}

void ChannelWindow::SetUpDialogSlot_Snapshot_BMP()
{
    QString bmp_path = path + QString("/Snapshot_BMP.bmp");

    QByteArray bmp_path_ByteArray = bmp_path.toLocal8Bit();

    CHAR* psz = bmp_path_ByteArray.data();

    QCAP_SNAPSHOT_BMP( m_hVideoDevice[m_nChannelWindow], psz );
}

void ChannelWindow::SetUpDialogSlot_Snapshot_JPG()
{
    QString jpg_path = path + QString("/Snapshot_JPG.jpg");

    QByteArray jpg_path_ByteArray =jpg_path.toLocal8Bit();

    CHAR* psz = jpg_path_ByteArray.data();

    QCAP_SNAPSHOT_JPG( m_hVideoDevice[m_nChannelWindow], psz, 100 );
}

void ChannelWindow::SetUpDialogSlot_VideoQuality()
{
    VideoQualityDlg vodeo_quality(this);

    vodeo_quality.exec();
}

void ChannelWindow::SetUpDialogSlot_FileRecord()
{
    FileRecordDlg FileRecord(this);

    FileRecord.exec();
}

void ChannelWindow::SetUpDialogSlot_ShareRecord()
{
    ShareRecordDlg ShareRecord(this);

    ShareRecord.exec();
}

void ChannelWindow::SetUpDialogSlot_DEINTERLACE( int flag )
{
    if( m_hVideoDevice[0] )
    {
        if( flag == 0 )
        {
            QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[0], 0 );
        }
        else
        {
            QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[0], 1 );
        }
    }
}
void ChannelWindow::SetUpDialogSlot_CLONE( int flag )
{
    for( ULONG i = 0 ; i < 4 ; i++ )
    {
        if( m_hVideoDevice[i] )
        {
            if( flag == 0 )
            {
                QCAP_STOP( m_hCloneCapDev[i] );

                QCAP_DESTROY( m_hCloneCapDev[i] );

                m_hCloneCapDev[i] = NULL;

                switch (i) {
                case 0:
                    ui->CloneWindow1->close();
                    break;
                case 1:
                    ui->CloneWindow2->close();
                    break;
                case 2:
                    ui->CloneWindow3->close();
                    break;
                case 3:
                    ui->CloneWindow4->close();
                    break;
                default:
                    break;
                }
            }
            else
            {
                switch (i) {
                case 0:
                    QCAP_CREATE_CLONE( m_hVideoDevice[0], (HWND)ui->CloneWindow1->winId(), &m_hCloneCapDev[0], 1 );
                    SetUpDialogSlot_DisplayWindow();
                    break;
                case 1:
                    QCAP_CREATE_CLONE( m_hVideoDevice[1], (HWND)ui->CloneWindow2->winId(), &m_hCloneCapDev[1], 1 );
                    SetUpDialogSlot_DisplayWindow();
                    break;
                case 2:
                    QCAP_CREATE_CLONE( m_hVideoDevice[2], (HWND)ui->CloneWindow3->winId(), &m_hCloneCapDev[2], 1 );
                    SetUpDialogSlot_DisplayWindow();
                    break;
                case 3:
                    QCAP_CREATE_CLONE( m_hVideoDevice[3], (HWND)ui->CloneWindow4->winId(), &m_hCloneCapDev[3], 1 );
                    SetUpDialogSlot_DisplayWindow();
                    break;
                default:
                    break;
                }

                if( m_hCloneCapDev[i] != 0 )
                {
                    QCAP_RUN( m_hCloneCapDev[i] );

                    QCAP_SET_AUDIO_VOLUME( m_hCloneCapDev[i], 0 );
                }
            }
        }
    }

}

void ChannelWindow::SetUpDialogSlot_DisplayWindow()
{
    if(m_nChannelWindow != 4)
    {
        m_setupdlg->ui->pushBTN_AudioInput->setEnabled(true);

        m_setupdlg->ui->pushBTN_SnapshotBMP->setEnabled(true);

        m_setupdlg->ui->pushBTN_SnapshotJPG->setEnabled(true);

        m_setupdlg->ui->pushBTN_VideoInpur->setEnabled(true);

        m_setupdlg->ui->pushBTN_VideoQuality->setEnabled(true);
    }
    else
    {
        m_setupdlg->ui->pushBTN_AudioInput->setEnabled(false);

        m_setupdlg->ui->pushBTN_SnapshotBMP->setEnabled(false);

        m_setupdlg->ui->pushBTN_SnapshotJPG->setEnabled(false);

        m_setupdlg->ui->pushBTN_VideoInpur->setEnabled(false);

        m_setupdlg->ui->pushBTN_VideoQuality->setEnabled(false);
    }

    switch (m_nChannelWindow) {
    case 0:
        ui->PreviewWindow2->close();

        ui->PreviewWindow3->close();

        ui->PreviewWindow4->close();

        ui->CloneWindow2->close();

        ui->CloneWindow3->close();

        ui->CloneWindow4->close();

        ui->PreviewWindow1->move(0,0);

        ui->PreviewWindow1->resize(this->width(),this->height());

        ui->PreviewWindow1->show();

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 0 ], 100 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 1 ], 0 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 2 ], 0 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 3 ], 0 );

        if(m_hCloneCapDev[0])
        {
            ui->CloneWindow1->move(this->width()-360,this->height()-240);

            ui->CloneWindow1->resize(360,240);

            ui->CloneWindow1->show();
        }
        break;
    case 1:
        ui->PreviewWindow1->close();

        ui->PreviewWindow3->close();

        ui->PreviewWindow4->close();

        ui->CloneWindow1->close();

        ui->CloneWindow3->close();

        ui->CloneWindow4->close();

        ui->PreviewWindow2->move(0,0);

        ui->PreviewWindow2->resize(this->width(),this->height());

        ui->PreviewWindow2->show();

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 0 ], 0 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 1 ], 100 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 2 ], 0 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 3 ], 0 );

        if(m_hCloneCapDev[1])
        {
            ui->CloneWindow2->move(this->width()-360,this->height()-240);

            ui->CloneWindow2->resize(360,240);

            ui->CloneWindow2->show();
        }
        break;
    case 2:
        ui->PreviewWindow2->close();

        ui->PreviewWindow1->close();

        ui->PreviewWindow4->close();

        ui->CloneWindow2->close();

        ui->CloneWindow1->close();

        ui->CloneWindow4->close();

        ui->PreviewWindow3->move(0,0);

        ui->PreviewWindow3->resize(this->width(),this->height());

        ui->PreviewWindow3->show();

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 0 ], 0 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 1 ], 0 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 2 ], 100 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 3 ], 0 );

        if(m_hCloneCapDev[2])
        {
            ui->CloneWindow3->move(this->width()-360,this->height()-240);

            ui->CloneWindow3->resize(360,240);

            ui->CloneWindow3->show();
        }
        break;
    case 3:
        ui->PreviewWindow2->close();

        ui->PreviewWindow3->close();

        ui->PreviewWindow1->close();

        ui->CloneWindow2->close();

        ui->CloneWindow3->close();

        ui->CloneWindow1->close();

        ui->PreviewWindow4->move(0,0);

        ui->PreviewWindow4->resize(this->width(),this->height());

        ui->PreviewWindow4->show();

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 0 ], 0 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 1 ], 0 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 2 ], 0 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 3 ], 100 );

        if(m_hCloneCapDev[3])
        {
            ui->CloneWindow4->move(this->width()-360,this->height()-240);

            ui->CloneWindow4->resize(360,240);

            ui->CloneWindow4->show();
        }
        break;
    case 4:
        ui->PreviewWindow1->move(0,0);

        ui->PreviewWindow2->move(this->width()/2,0);

        ui->PreviewWindow3->move(0,this->height()/2);

        ui->PreviewWindow4->move(this->width()/2,this->height()/2);

        ui->PreviewWindow1->resize(this->width()/2,this->height()/2);

        ui->PreviewWindow2->resize(this->width()/2,this->height()/2);

        ui->PreviewWindow3->resize(this->width()/2,this->height()/2);

        ui->PreviewWindow4->resize(this->width()/2,this->height()/2);

        ui->CloneWindow1->move(this->width()/2-160,this->height()/2-120);

        ui->CloneWindow2->move(this->width()-160,this->height()/2-120);

        ui->CloneWindow3->move((this->width()/2)-160,this->height()-120);

        ui->CloneWindow4->move(this->width()-160,this->height()-120);

        ui->CloneWindow1->resize(160,120);

        ui->CloneWindow2->resize(160,120);

        ui->CloneWindow3->resize(160,120);

        ui->CloneWindow4->resize(160,120);

        ui->PreviewWindow1->show();

        ui->PreviewWindow2->show();

        ui->PreviewWindow3->show();

        ui->PreviewWindow4->show();

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 0 ], 0 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 1 ], 0 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 2 ], 0 );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ 3 ], 0 );

        for(ULONG i = 0 ; i < 4 ; i++)
        {
            if(m_hCloneCapDev[i] != 0)
            {
                switch (i) {
                case 0:
                    ui->CloneWindow1->show();
                    break;
                case 1:
                    ui->CloneWindow2->show();
                    break;
                case 2:
                    ui->CloneWindow3->show();
                    break;
                case 3:
                    ui->CloneWindow4->show();
                    break;
                default:
                    break;
                }
            }
        }
        break;
    default:
        break;
    }
}

void ChannelWindow::mouseMoveEvent(QMouseEvent *event)
{
    if(event->buttons()&Qt::LeftButton)
    {
        move(event->globalPos()- dragPosition);

        event->accept();
    }
}

void ChannelWindow::mousePressEvent(QMouseEvent *event)
{
    if(event->button()==Qt::LeftButton)
    {
        dragPosition=event->globalPos()-frameGeometry().topLeft();

        event->accept();
    }
}

void ChannelWindow::mouseDoubleClickEvent( QMouseEvent * event )
{
    if( event->button()==Qt::LeftButton )
    {
        QDesktopWidget *desktop = QApplication::desktop();

        QRect screen = desktop->screenGeometry();

        if( m_bFullScreen == FALSE)
        {
            this->move(0,0);

            this->resize(screen.width(),screen.height());

            ui->PreviewWindow1->move(0,0);

            ui->PreviewWindow2->move(this->width()/2,0);

            ui->PreviewWindow3->move(0,this->height()/2);

            ui->PreviewWindow4->move(this->width()/2,this->height()/2);

            ui->PreviewWindow1->resize(this->width()/2,this->height()/2);

            ui->PreviewWindow2->resize(this->width()/2,this->height()/2);

            ui->PreviewWindow3->resize(this->width()/2,this->height()/2);

            ui->PreviewWindow4->resize(this->width()/2,this->height()/2);

            ui->CloneWindow1->move(this->width()/2-160,this->height()/2-120);

            ui->CloneWindow2->move(this->width()-160,this->height()/2-120);

            ui->CloneWindow3->move((this->width()/2)-160,this->height()-120);

            ui->CloneWindow4->move(this->width()-160,this->height()-120);

            ui->CloneWindow1->resize(160,120);

            ui->CloneWindow2->resize(160,120);

            ui->CloneWindow3->resize(160,120);

            ui->CloneWindow4->resize(160,120);

            m_bFullScreen = TRUE;
        }
        else
        {
            this->move((screen.width()-960)/2,(screen.height()-540)/2);

            this->resize(960,540);

            ui->PreviewWindow1->move(0,0);

            ui->PreviewWindow2->move(this->width()/2,0);

            ui->PreviewWindow3->move(0,this->height()/2);

            ui->PreviewWindow4->move(this->width()/2,this->height()/2);

            ui->PreviewWindow1->resize(this->width()/2,this->height()/2);

            ui->PreviewWindow2->resize(this->width()/2,this->height()/2);

            ui->PreviewWindow3->resize(this->width()/2,this->height()/2);

            ui->PreviewWindow4->resize(this->width()/2,this->height()/2);

            ui->CloneWindow1->move(this->width()/2-160,this->height()/2-120);

            ui->CloneWindow2->move(this->width()-160,this->height()/2-120);

            ui->CloneWindow3->move((this->width()/2)-160,this->height()-120);

            ui->CloneWindow4->move(this->width()-160,this->height()-120);

            ui->CloneWindow1->resize(160,120);

            ui->CloneWindow2->resize(160,120);

            ui->CloneWindow3->resize(160,120);

            ui->CloneWindow4->resize(160,120);

            m_bFullScreen = FALSE;
        }

        SetUpDialogSlot_DisplayWindow();

        event->accept();
    }
}

void ChannelWindow::SetUpDialogSlot_DestroyAP()
{
    HwUninitialize();

    exit(0);
}
