﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

using QCAP.NET;

namespace StreamCatcherDemo
{
    public partial class MonitorsInfoControl : Form
    {
        public MySetupControl m_pSetupControl;

        public string[] myDisplayName = new string[5];

        public Rectangle[] myWorkingArea = new Rectangle[5];
        
        public MonitorsInfoControl()
        {
            InitializeComponent();
        }

        private class ScreenObj
        {
            public Screen screen = null;

            public ScreenObj(Screen scr)
            {
                screen = scr;
            }

            public override string ToString()
            {
                return screen.DeviceName;
            }
        }

        private void MonitorsInfoControl_Load(object sender, EventArgs e)
        {
            int i = 0;

            foreach(Screen screen in Screen.AllScreens)
            {
                comboBoxMonitorList0.Items.Add(new ScreenObj(screen));

                comboBoxMonitorList1.Items.Add(new ScreenObj(screen));

                comboBoxMonitorList2.Items.Add(new ScreenObj(screen));

                comboBoxMonitorList3.Items.Add(new ScreenObj(screen));

                comboBoxMonitorList4.Items.Add(new ScreenObj(screen));

                myDisplayName[i] = screen.DeviceName;

                myDisplayName[i] = myDisplayName[i].Substring(0, 12);                

                myWorkingArea[i] = screen.WorkingArea;

                i++;
            }

            comboBoxMonitorList0.SelectedIndex = 0;

            comboBoxMonitorList1.SelectedIndex = 0;

            comboBoxMonitorList2.SelectedIndex = 0;

            comboBoxMonitorList3.SelectedIndex = 0;

            comboBoxMonitorList4.SelectedIndex = 0;
        }

        private void MonitorsInfoControl_FormClosed(object sender, FormClosedEventArgs e)
        {

        }

        private void MonitorsInfoControl_Shown(object sender, EventArgs e)
        {
            Screen myScreen = Screen.FromControl(this);

            textBoxCurrentMonitor.Text = myScreen.DeviceName;

            textBoxNumOfMonitors.Text = Screen.AllScreens.Length.ToString();

            textBoxWorkingArea.Text = myScreen.WorkingArea.ToString();

            textBoxScreenSize.Text = myScreen.Bounds.ToString();
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            string[] strSelectedName = new string[4];           
 
            ScreenObj screenobj1 = (ScreenObj)comboBoxMonitorList1.SelectedItem;

            strSelectedName[0] = screenobj1.screen.DeviceName;

            strSelectedName[0] = strSelectedName[0].Substring(0, 12);

            ScreenObj screenobj2 = (ScreenObj)comboBoxMonitorList2.SelectedItem;

            strSelectedName[1] = screenobj2.screen.DeviceName;

            strSelectedName[1] = strSelectedName[1].Substring(0, 12);

            ScreenObj screenobj3 = (ScreenObj)comboBoxMonitorList3.SelectedItem;

            strSelectedName[2] = screenobj3.screen.DeviceName;

            strSelectedName[2] = strSelectedName[2].Substring(0, 12);

            ScreenObj screenobj4 = (ScreenObj)comboBoxMonitorList4.SelectedItem;

            strSelectedName[3] = screenobj4.screen.DeviceName;

            strSelectedName[3] = strSelectedName[3].Substring(0, 12);

            /*              
            // CHECK MAIN SCREEN
            //
            bool bMainScreen = false;

            bMainScreen = strSelectedName[0].StartsWith("\\\\.\\DISPLAY5", System.StringComparison.CurrentCultureIgnoreCase);

            if (bMainScreen) { return; }

            bMainScreen = strSelectedName[1].StartsWith("\\\\.\\DISPLAY5", System.StringComparison.CurrentCultureIgnoreCase);

            if (bMainScreen) { return; }

            bMainScreen = strSelectedName[2].StartsWith("\\\\.\\DISPLAY5", System.StringComparison.CurrentCultureIgnoreCase);

            if (bMainScreen) { return; }

            bMainScreen = strSelectedName[3].StartsWith("\\\\.\\DISPLAY5", System.StringComparison.CurrentCultureIgnoreCase);

            if (bMainScreen) { return; }
            */

            // CHECK DUPLICATE SCREEN
            //
            if ((strSelectedName[0] == strSelectedName[1]) || (strSelectedName[0] == strSelectedName[2]) || (strSelectedName[0] == strSelectedName[3])) { return; }

            if ((strSelectedName[1] == strSelectedName[0]) || (strSelectedName[1] == strSelectedName[2]) || (strSelectedName[1] == strSelectedName[3])) { return; }

            if ((strSelectedName[2] == strSelectedName[0]) || (strSelectedName[2] == strSelectedName[1]) || (strSelectedName[2] == strSelectedName[3])) { return; }

            if ((strSelectedName[3] == strSelectedName[0]) || (strSelectedName[3] == strSelectedName[1]) || (strSelectedName[3] == strSelectedName[2])) { return; }           

            Hide();

            int nScreenLen = Screen.AllScreens.Length;

            int i = 0;

            Point point = new Point();

            // MOVE CHANNEL TO ASSIGNED POSITION
            //

            // CH01
            //
            for (i = 0; i < nScreenLen; i++)
            {
                if (strSelectedName[0] == myDisplayName[i])
                {
                    point.X = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[0].Left = myWorkingArea[i].Left;

                    point.Y = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[0].Top = myWorkingArea[i].Top;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[0].Size = new System.Drawing.Size(myWorkingArea[i].Width, myWorkingArea[i].Height);

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[0].Location = point;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[0].Visible = true;

                    break;
                }
            }

            // CH02
            //
            for (i = 0; i < nScreenLen; i++)
            {
                if (strSelectedName[1] == myDisplayName[i])
                {
                    point.X = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[1].Left = myWorkingArea[i].Left;

                    point.Y = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[1].Top = myWorkingArea[i].Top;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[1].Size = new System.Drawing.Size(myWorkingArea[i].Width, myWorkingArea[i].Height);

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[1].Location = point;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[1].Visible = true;

                    break;
                }
            }

            // CH03
            //
            for (i = 0; i < nScreenLen; i++)
            {
                if (strSelectedName[2] == myDisplayName[i])
                {
                    point.X = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[2].Left = myWorkingArea[i].Left;

                    point.Y = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[2].Top = myWorkingArea[i].Top;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[2].Size = new System.Drawing.Size(myWorkingArea[i].Width, myWorkingArea[i].Height);

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[2].Location = point;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[2].Visible = true;

                    break;
                }
            }

            // CH04
            //
            for (i = 0; i < nScreenLen; i++)
            {
                if (strSelectedName[3] == myDisplayName[i])
                {
                    point.X = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[3].Left = myWorkingArea[i].Left;

                    point.Y = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[3].Top = myWorkingArea[i].Top;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[3].Size = new System.Drawing.Size(myWorkingArea[i].Width, myWorkingArea[i].Height);

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[3].Location = point;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[3].Visible = true;

                    break;
                }
            }

            /*
            for (i = 0; i < 4; i++ )
            {
                bool bFirstScreen = false, bSecondScreen = false, bThirdScreen = false, bFourthScreen = false;

                bFirstScreen = strName[i].StartsWith("\\\\.\\DISPLAY5", System.StringComparison.CurrentCultureIgnoreCase);

                bSecondScreen = strName[i].StartsWith("\\\\.\\DISPLAY2", System.StringComparison.CurrentCultureIgnoreCase);

                bThirdScreen = strName[i].StartsWith("\\\\.\\DISPLAY3", System.StringComparison.CurrentCultureIgnoreCase);

                bFourthScreen = strName[i].StartsWith("\\\\.\\DISPLAY1", System.StringComparison.CurrentCultureIgnoreCase);

                if (bFirstScreen)
                {
                    point.X = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Left = myWorkingArea[0].Left;

                    point.Y = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Top = myWorkingArea[0].Top;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Size = new System.Drawing.Size(myWorkingArea[0].Width, myWorkingArea[0].Height);

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Location = point;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Visible = true;
                }

                if (bSecondScreen)
                {
                    point.X = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Left = myWorkingArea[1].Left;

                    point.Y = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Top = myWorkingArea[1].Top;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Size = new System.Drawing.Size(myWorkingArea[1].Width, myWorkingArea[1].Height);

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Location = point;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Visible = true;
                }

                if (bThirdScreen)
                {
                    point.X = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Left = myWorkingArea[2].Left;

                    point.Y =  m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Top = myWorkingArea[2].Top;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Size = new System.Drawing.Size(myWorkingArea[2].Width, myWorkingArea[2].Height);

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Location = point;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Visible = true;
                }

                if (bFourthScreen)
                {
                    point.X = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Left = myWorkingArea[3].Left;

                    point.Y = m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Top = myWorkingArea[3].Top;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Size = new System.Drawing.Size(myWorkingArea[3].Width, myWorkingArea[3].Height);

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Location = point;

                    m_pSetupControl.m_pMainForm.m_pChannelForm_LIVE[i].Visible = true;
                }
            }
            */
        }

        private void comboBoxMonitorList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ScreenObj screenobj = (ScreenObj)comboBoxMonitorList0.SelectedItem;          

            textBoxCurrentMonitor.Text = screenobj.screen.DeviceName;

            textBoxWorkingArea.Text = screenobj.screen.WorkingArea.ToString();

            textBoxScreenSize.Text = screenobj.screen.Bounds.ToString();

            int nLeft = 0;

            nLeft = screenobj.screen.WorkingArea.Left;

            int nTop = screenobj.screen.WorkingArea.Top;

            int nRight = screenobj.screen.WorkingArea.Right;

            int nBottom = screenobj.screen.WorkingArea.Bottom;
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            Hide();
        }


    }
}
