// AnalogDeviceVideoGraph.cpp: implementation of the CAnalogDeviceVideoGraph class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "AnalogDeviceVideoGraph.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

static const GUID PROPSETID_AMEBDAD_CUSTOM_PROP = { 0xD1E5209F, 0x68FD, 0x4529, 0xBE, 0xE0, 0x5E, 0x7A, 0x1F, 0x47, 0x92, 0x00 }; // CUSTOM PROPERITY { D1E5209F-68FD-4529-BEE0-5E7A1F4792XX }

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

VOID CAnalogDeviceVideoGraph::SC_DEBUG( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[SC510] [00000000] ";

	va_list marker;

	va_start( marker, fmt );

	StringCbPrintfA( pszDebugDumpMessage + 8, sizeof(pszDebugDumpMessage), "[%08X] ", this );

	StringCbVPrintfA( pszDebugDumpMessage + 8 + 1 + 10, sizeof(pszDebugDumpMessage), fmt, marker );

	va_end( marker );

	StringCbCatA( pszDebugDumpMessage, sizeof(pszDebugDumpMessage), "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CAnalogDeviceVideoGraph::CAnalogDeviceVideoGraph()
{
//	SC_DEBUG( "CAnalogDeviceVideoGraph::CAnalogDeviceVideoGraph()" );

	m_pCaptureSourceBaseFilter = NULL;

	m_pSampleGrabberBaseFilter = NULL;

	m_pColorConverterBaseFilter = NULL;

	m_pVideoNullRendererBaseFilter = NULL;

	m_pSampleGrabber = NULL;

	m_oSampleGrabber.SetCallback( NULL, NULL );

	m_hDisplayWindow = NULL;

	m_pVideoWindow = NULL;

	m_nColorSpaceType = 0x00000000;

	m_nWidth = 0;

	m_nHeight = 0;

	m_nBitCount = 0;

	m_dFrameRate = 0.0;
}

CAnalogDeviceVideoGraph::~CAnalogDeviceVideoGraph()
{
//	SC_DEBUG( "CAnalogDeviceVideoGraph::~CAnalogDeviceVideoGraph()" );

	CAnalogDeviceVideoGraph::Close( FALSE );
}

BOOL CAnalogDeviceVideoGraph::Close( BOOL bDumpDebugMessage )
{
	if( bDumpDebugMessage ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Close()" ); }

	if( m_pCommonMediaControl ) { if( GetState() == State_Running ) { Stop(); } }

	if( m_pCommonMediaControl ) { if( GetState() == State_Paused ) { Stop(); } }

	m_oSampleGrabber.SetCallback( NULL, NULL );

	RELEASE( m_pVideoWindow );

	RELEASE( m_pSampleGrabber );

	RELEASE( m_pVideoNullRendererBaseFilter );

	RELEASE( m_pColorConverterBaseFilter );

	RELEASE( m_pSampleGrabberBaseFilter );

	RELEASE( m_pCaptureSourceBaseFilter );

	m_hDisplayWindow = NULL;

	m_nColorSpaceType = 0x00000000;

	m_nWidth = 0;

	m_nHeight = 0;

	m_nBitCount = 0;

	m_dFrameRate = 0.0;

	return CloseGraphBuilder( bDumpDebugMessage );
}

BOOL CAnalogDeviceVideoGraph::Create( PWSTR              pwszDevName, 
									 
									  HWND               hDisplayWindow, 

									  PF_BUFFER_CALLBACK pBufferCB, 

									  PVOID              pUserData )
{
	WCHAR pwszFilterNameBuffer[ 256 ];

	StringCchPrintfW( pwszFilterNameBuffer, 256, L"%ws", pwszDevName );

	m_hDisplayWindow = hDisplayWindow;

	// CREATE GRAPH BUILDER RESOURCE
	//
	if( FALSE == CreateGraphBuilder() ) return FALSE; 

	// FIND/ADD CAPTURE SOURCE FILTER INTO GRAPH
	//
	if( FALSE == FindFilter( &CLSID_VideoInputDeviceCategory, pwszFilterNameBuffer, 0, &m_pCaptureSourceBaseFilter, pwszFilterNameBuffer, 256 ) ) return FALSE;
	
	if( FALSE == AddFilter( m_pCaptureSourceBaseFilter, pwszFilterNameBuffer ) ) return FALSE;

	// FIND/ADD SAMPLE GRABBER FILTER INTO GRAPH
	//
	if( FAILED(CoCreateInstance( CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (VOID **)(&m_pSampleGrabberBaseFilter) )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( CoCreateInstance(CLSID_SampleGrabber) ) ERROR!!" ); return FALSE; }

	if( FALSE == AddFilter( m_pSampleGrabberBaseFilter, L"Sample Grabber" ) ) return FALSE;

	if( FALSE == FindFilter( &CLSID_LegacyAmFilterCategory, L"Custom Color Converter Filter", 0, &m_pColorConverterBaseFilter, pwszFilterNameBuffer, 256 ) ) return FALSE;

	if( FALSE == AddFilter( m_pColorConverterBaseFilter, L"Custom Color Converter Filter" ) ) return FALSE;
				
	if( FAILED(CoCreateInstance( hDisplayWindow ? CLSID_VideoRendererDefault : CLSID_NullRenderer, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (VOID **)(&m_pVideoNullRendererBaseFilter) )) ) {

		SC_DEBUG( "CAnalogDeviceVideoGraph::Create( CoCreateInstance(CLSID_VideoRendererDefault/CLSID_NullRenderer) ) ERROR!!" );

		return FALSE;
	}	
	if( FALSE == AddFilter( m_pVideoNullRendererBaseFilter, hDisplayWindow ? L"Video Renderer" : L"Null Renderer" ) ) return FALSE;

	// OBTAIN PROPERTY INTERFACE FROM FILTER
	//				
	if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface( NULL, NULL, m_pVideoNullRendererBaseFilter, IID_IVideoWindow, (VOID **)(&m_pVideoWindow) )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( FindInterface(IID_IVideoWindow) )" ); }

	if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface( NULL, NULL, m_pSampleGrabberBaseFilter, IID_ISampleGrabber, (VOID **)(&m_pSampleGrabber) )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( FindInterface(IID_ISampleGrabber) )" ); }

	if( NULL != m_pSampleGrabber ) {

		if( FAILED(m_pSampleGrabber->SetOneShot( FALSE )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( ISampleGrabber::SetOneShot() ) ERROR!!" ); return FALSE; }

		if( FAILED(m_pSampleGrabber->SetBufferSamples( FALSE )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( ISampleGrabber::SetBufferSamples() ) ERROR!!" ); return FALSE; }

		if( FAILED(m_pSampleGrabber->SetCallback( &m_oSampleGrabber, 0 )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( ISampleGrabber::SetCallback() ) ERROR!!" ); return FALSE; }

		m_oSampleGrabber.SetCallback( pBufferCB, pUserData );
	}

	// SET DEFAULT FORMAT
	// 
	if( FALSE == GetFormat( &m_nColorSpaceType, &m_nWidth, &m_nHeight, &m_nBitCount, &m_dFrameRate ) ) return FALSE;

	// DISCONNECT FILTERS
	//
	if( FALSE == DisconnectFilters( m_pCaptureSourceBaseFilter, m_pSampleGrabberBaseFilter ) ) { ; }

	if( FALSE == DisconnectFilters( m_pSampleGrabberBaseFilter, m_pColorConverterBaseFilter ) ) { ; }

	if( FALSE == DisconnectFilters( m_pColorConverterBaseFilter, m_pVideoNullRendererBaseFilter ) ) { ; }

	// CONNECT FILTERS
	//
	if( FALSE == ConnectFilters( m_pCaptureSourceBaseFilter, m_pSampleGrabberBaseFilter ) ) return FALSE;

	if( FALSE == ConnectFilters( m_pSampleGrabberBaseFilter, m_pColorConverterBaseFilter ) ) return FALSE;

	if( FALSE == ConnectFilters( m_pColorConverterBaseFilter, m_pVideoNullRendererBaseFilter ) ) return FALSE;
	
	// SET DISPLAY WINDOWS
	// 
	if( NULL != m_pVideoWindow &&

		NULL != hDisplayWindow ) {
	
		if( FAILED(m_pVideoWindow->put_Owner( (OAHWND)(hDisplayWindow) )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::SetFormat( IVideoWindow::put_Owner() ) ERROR!!" ); return FALSE; }

		if( FAILED(m_pVideoWindow->put_WindowStyle( (WS_CHILD) )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::SetFormat( IVideoWindow::put_WindowStyle() ) ERROR!!" ); return FALSE; }

		if( FAILED(m_pVideoWindow->put_MessageDrain( (OAHWND)(hDisplayWindow) )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::SetFormat( IVideoWindow::put_MessageDrain() ) ERROR!!" ); return FALSE; }

		if( FALSE == RefreshDisplayWindow() ) return FALSE;
	}

	// COMPLETE
	//
	SC_DEBUG( "CAnalogDeviceVideoGraph::Create()" );

	return TRUE;
}

BOOL CAnalogDeviceVideoGraph::GetFormat( ULONG *  pColorSpaceType,
										
										 ULONG *  pWidth,
										 
										 ULONG *  pHeight,
										 
										 ULONG *  pBitCount,
										 
										 double * pFrameRate )
{
	AM_MEDIA_TYPE * pmt = NULL;

	CComPtr< IPin > pPin = NULL;

	CComPtr< IEnumMediaTypes > pEnumMediaTypes = NULL;

	if( FAILED(m_pCommonCaptureGraphBuilder2->FindPin( m_pCaptureSourceBaseFilter, PINDIR_OUTPUT, NULL, &MEDIATYPE_Video, FALSE, 0, &pPin )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetFormat( ICaptureGraphBuilder2::FindPin( Video ) ) ERROR!!" ); return FALSE; }

	if( FAILED(pPin->EnumMediaTypes( &pEnumMediaTypes )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetFormat( IPin::EnumMediaTypes() ) ERROR!!" ); return FALSE; }

	if( FAILED(pEnumMediaTypes->Next( 1, &pmt, NULL )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::GetFormat( IAMStreamConfig::GetFormat() ) ERROR!!" ); return FALSE; }

	ULONG  cso = ((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biCompression;

	ULONG  cxo = ((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biWidth;

	ULONG  cyo = ((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biHeight;

	ULONG  czo = ((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biBitCount;

	double fps = (double)(10000000.0 / ((VIDEOINFOHEADER *)(pmt->pbFormat))->AvgTimePerFrame);

	if( pColorSpaceType ) { *pColorSpaceType = cso; }

	if( pWidth ) { *pWidth = cxo; }

	if( pHeight ) { *pHeight = cyo; }

	if( pBitCount ) { *pBitCount = czo; }

	if( pFrameRate ) { *pFrameRate = fps; }

	SC_DEBUG( "CAnalogDeviceVideoGraph::GetFormat( %08X  %d  %d  %d  %2.6f )", cso, cxo, cyo, czo, fps );

	DeleteMediaType( pmt );

	pmt = NULL;

	return TRUE;
}

BOOL CAnalogDeviceVideoGraph::RefreshDisplayWindow() 
{
	CRect oOwnerWindowRect( 0, 0, 0, 0 );

	if( NULL == m_pVideoWindow ) { SC_DEBUG( "CAnalogDeviceVideoGraph::RefreshDisplayWindow( NULL ) ERROR!!" ); return FALSE; }

	OAHWND hWndOwner = NULL;

	if( FAILED(m_pVideoWindow->get_Owner( &hWndOwner )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::RefreshDisplayWindow( IVideoWindow::get_Owner() ) ERROR!!" ); return FALSE; }

	GetClientRect( (HWND)(hWndOwner), &oOwnerWindowRect );

	ULONG cx = oOwnerWindowRect.Width();

	ULONG cy = oOwnerWindowRect.Height();

	ULONG x = 0;

	ULONG y = 0;

	if( FAILED(m_pVideoWindow->SetWindowPosition( x, y, cx, cy )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::RefreshDisplayWindow( IVideoWindow::SetWindowPosition() ) ERROR!!" ); return FALSE; }

//	SC_DEBUG( "CAnalogDeviceVideoGraph::RefreshDisplayWindow()" );

	return TRUE;
}
