Attribute VB_Name = "Module1"
'**********************************************************
' Enum Constant Value
'**********************************************************

' RETURN OF CALLBACK
'
Public Enum ReturnOfCallbackEnum

    QCAP_RT_OK = &H0

    QCAP_RT_FAIL = &H1

End Enum
    
'  RESULT OF FUNCTION
'
Public Enum ResultOfFunction

    QCAP_RS_SUCCESSFUL = &H0
    
    QCAP_RS_ERROR_GENERAL = &H1
    
    QCAP_RS_ERROR_OUT_OF_MEMORY = &H2
    
    QCAP_RS_ERROR_OUT_OF_RESOURCE = &H3
    
    QCAP_RS_ERROR_INVALID_DEVICE = &H4

    QCAP_RS_ERROR_INVALID_PARAMETER = &H5

    QCAP_RS_ERROR_NON_SUPPORT = &H6

    QCAP_RS_ERROR_TIMEOUT = &H7
    
End Enum

' INPUT VIDEO SOURCE
'
Public Enum InputVideoSourceEnum

    QCAP_INPUT_TYPE_COMPOSITE = 0

    QCAP_INPUT_TYPE_SVIDEO = 1

    QCAP_INPUT_TYPE_HDMI = 2

    QCAP_INPUT_TYPE_DVI_D = 3

    QCAP_INPUT_TYPE_COMPONENTS = 4

    QCAP_INPUT_TYPE_YCBCR = 4

    QCAP_INPUT_TYPE_DVI_A = 5

    QCAP_INPUT_TYPE_RGB = 5

    QCAP_INPUT_TYPE_VGA = 5

    QCAP_INPUT_TYPE_SDI = 6

    QCAP_INPUT_TYPE_AUTO = 7

End Enum

' INPUT AUDIO SOURCE
'
Public Enum InputAudioSourceEnum

    QCAP_INPUT_TYPE_EMBEDDED_AUDIO = 0

    QCAP_INPUT_TYPE_LINE_IN = 1

    QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE = 2

    QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN = 3

End Enum

' VIDEO STANDARD TYPE
'
Public Enum VideoStandardTypeEnum

    QCAP_STANDARD_TYPE_NTSC_M = &H1

    QCAP_STANDARD_TYPE_NTSC_M_J = &H2
    
    QCAP_STANDARD_TYPE_NTSC_433 = &H4
    
    QCAP_STANDARD_TYPE_PAL_M = &H200
    
    QCAP_STANDARD_TYPE_PAL_60 = &H800
    
    QCAP_STANDARD_TYPE_PAL_B = &H10
    
    QCAP_STANDARD_TYPE_PAL_D = &H20
    
    QCAP_STANDARD_TYPE_PAL_G = &H40
    
    QCAP_STANDARD_TYPE_PAL_H = &H80
    
    QCAP_STANDARD_TYPE_PAL_I = &H100
    
    QCAP_STANDARD_TYPE_PAL_N = &H400
    
    QCAP_STANDARD_TYPE_PAL_N_COMBO = &H100000
    
    'QCAP_STANDARD_TYPE_AUTO = &H80000000UL

End Enum


' VIDEO DEINTERLACE TYPE
'
Public Enum SoftwareDeinterlaceTypeEnum

    QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING = &H0

    QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE = &H1

End Enum


' ENCODER TYPE (RECORD PROPERTY)
'
Public Enum EncoderTypeEnum

    QCAP_ENCODER_TYPE_SOFTWARE = 0

    QCAP_ENCODER_TYPE_HARDWARE = 1 ' IT IS ONLY USED FOR HARDWARE COMPRESSION CAPTURE CARD, SUCH AS SC580 & SC590

    QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK = 2

    QCAP_ENCODER_TYPE_AMD_STREAM = 3

    QCAP_ENCODER_TYPE_NVIDIA_CUDA = 4

End Enum


' ENCODER VIDEO FORMAT (RECORD PROPERTY)
'
Public Enum VideoEncoderFormatEnum

    QCAP_ENCODER_FORMAT_H264 = 0
    
End Enum


' ENCODER AUDIO FORMAT (RECORD PROPERTY)
'
Public Enum AudioEncoderFormatEnum

    QCAP_ENCODER_FORMAT_PCM = 0

    QCAP_ENCODER_FORMAT_AAC = 1

    QCAP_ENCODER_FORMAT_AAC_RAW = 1

    QCAP_ENCODER_FORMAT_AAC_ADTS = 2

End Enum


' RECORD MODE (RECORD PROPERTY)
'
Public Enum RecordModeEnum

    QCAP_RECORD_MODE_VBR = 0
    
    QCAP_RECORD_MODE_CBR = 1

End Enum


' COLORSPACE TYPE
'
Public Enum ColorSpaceTypeEnum

    QCAP_COLORSPACE_TYEP_RGB24 = 0 ' 0xRRGGBB
    
    QCAP_COLORSPACE_TYEP_BGR24 = 1 ' 0xBBGGRR
    
    QCAP_COLORSPACE_TYEP_ARGB32 = 2 ' 0xAARRGGBB
    
    QCAP_COLORSPACE_TYEP_ABGR32 = 3 ' 0xAABBGGRR
    
    QCAP_COLORSPACE_TYEP_YUY2 = &H32595559 'MAKEFOURCC('Y', 'U', 'Y', '2')
    
    QCAP_COLORSPACE_TYEP_UYVY = &H59565955 'MAKEFOURCC('U', 'Y', 'V', 'Y')
    
    QCAP_COLORSPACE_TYEP_YV12 = &H32315659 'MAKEFOURCC('Y', 'V', '1', '2')

End Enum


' DOWNSCALE MODE (RECORD PROPERTY)
'
Public Enum DownScaleModeEnum

    QCAP_DOWNSCALE_MODE_OFF = 0 ' (1920, 1080) * (1 / 1) = (1920, 1080)
    
    QCAP_DOWNSCALE_MODE_2_3 = 1 ' (1920, 1080) * (2 / 3) = (1280,  720)
    
    QCAP_DOWNSCALE_MODE_1_2 = 2 ' (1920, 1080) * (1 / 2) = ( 960,  480)
    
    QCAP_DOWNSCALE_MODE_1_4 = 3 ' (1920, 1080) * (1 / 4) = ( 480,  240)

End Enum

' RECORD FLAG (RECORD PROPERTY)
'
Public Enum RecordFlagEnum

    QCAP_RECORD_FLAG_FULL = &H7

    QCAP_RECORD_FLAG_FILE = &H1

    QCAP_RECORD_FLAG_ENCODE = &H2

    QCAP_RECORD_FLAG_DISPLAY = &H4

End Enum


 ' BROADCAST FLAG (BROADCAST PROPERTY)
'
Public Enum BroadCastFlagEnum

    QCAP_BROADCAST_FLAG_FULL = &H7

    QCAP_BROADCAST_FLAG_NETWORK = &H1

    QCAP_BROADCAST_FLAG_ENCODE = &H2

    QCAP_BROADCAST_FLAG_DISPLAY = &H4

End Enum

' FONT STYLE
'
Public Enum FontStyleEnum

    QCAP_FONT_STYLE_REGULAR = &H0

    QCAP_FONT_STYLE_BOLD = &H1

    QCAP_FONT_STYLE_ITALIC = &H2

    QCAP_FONT_STYLE_BOLDITALIC = &H3

    QCAP_FONT_STYLE_UNDERLINE = &H4

    QCAP_FONT_STYLE_STRIKEOUT = &H8

End Enum

' OSD SEQUENCE STYLE (OSD PROPERTY)
'
Public Enum SequenceStyleEnum

    ' GENERAL DEVICE: FOREMOST -> PREVIEW CALLBACK -> RECORDING (ENCODING) -> AFTERMOST
    '
    ' SHARE RECORDING: FOREMOST ->                    RECORDING (ENCODING) -> AFTERMOST
    '
    ' SHARE STREAMING: FOREMOST ->                    STREAMING (ENCODING) -> AFTERMOST
    '
    QCAP_SEQUENCE_STYLE_FOREMOST = &H0

    QCAP_SEQUENCE_STYLE_BEFORE_ENCODE = &H1

    QCAP_SEQUENCE_STYLE_AFTERMOST = &H2

End Enum

Private Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, Optional ByVal dSampleTime As Double = 0#) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, Optional ByVal dSampleTime As Double = 0#) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal bIsKeyFrame As Long) As ResultOfFunction

Public Declare Function QCAP_DESTROY Lib "QCAP.DLL" (ByVal pDevice As Long) As ResultOfFunction

'  FORMAT CHANGED CALLBACK FUNCTION
'
Public Function on_process_format_changed(ByVal pDevice As Long, ByVal nVideoInput As Long, ByVal nAudioInput As Long, ByVal nVideoWidth As Long, ByVal nVideoHeight As Long, ByVal bVideoIsInterleaved As Long, ByVal nVideoFrameRate As Long, ByVal nAudioChannels As Long, ByVal nAudioBitsPerSample As Long, ByVal nAudioSampleFrequency As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum

    Dim nCH As Long

    nCH = pUserData
    
    Dim cMessage As String
    
    Form1.m_nVideoWidth = nVideoWidth

    Form1.m_nVideoHeight = nVideoHeight

    Form1.m_nVideoFrameRate = nVideoFrameRate
    
    Dim nVH As Long
    
    Dim strFrameType As String
    
    strFrameType = " P "
    
    Dim strVideoInput As String
    
    strVideoInput = ""
    
    Dim strAudioInput As String
    
    strAudioInput = ""
    
    If nVideoInput = 0 Then strVideoInput = "COMPOSITE"
    
    If nVideoInput = 1 Then strVideoInput = "SVIDEO"
    
    If nVideoInput = 2 Then strVideoInput = "HDMI"
    
    If nVideoInput = 3 Then strVideoInput = "DVI_D"
    
    If nVideoInput = 4 Then strVideoInput = "COMPONENTS (YCBCR)"
    
    If nVideoInput = 5 Then strVideoInput = "DVI_A (RGB / VGA)"
    
    If nVideoInput = 6 Then strVideoInput = "SDI"
    
    If nVideoInput = 7 Then strVideoInput = "AUTO"
    
    If nAudioInput = 0 Then strAudioInput = "EMBEDDED_AUDIO"
    
    If nAudioInput = 1 Then strAudioInput = "LINE_IN"

    If bVideoIsInterleaved = 1 Then
    
        nVH = nVideoHeight / 1
        
    Else
    
        nVH = nVideoHeight / 1
        
    End If
    
    If bVideoIsInterleaved = 1 Then
    
        strFrameType = " I "
        
    Else
    
        strFrameType = " P "
        
    End If

    ' OUTPUT FORMAT CHANGED MESSAGE
    '
    Dim strOutput As String
    
    If nCH = 0 Then
    
        strOutput = "CH01 INFO : " + CStr(nVideoWidth) + " x " + CStr(nVH) + strFrameType + " @" + CStr(nVideoFrameRate) + " FPS , " + CStr(nAudioChannels) + " CH x " + CStr(nAudioBitsPerSample) + " BITS x " + CStr(nAudioSampleFrequency) + " HZ , " + " VIDEO INPUT : " + strVideoInput + " , " + " AUDIO INPUT : " + strAudioInput
        
        Form1.m_cSetupControl.m_scDeviceFormatInformation1.Caption = strOutput
        
    End If
    
    If nCH = 1 Then
    
        strOutput = "CH02 INFO : " + CStr(nVideoWidth) + " x " + CStr(nVH) + strFrameType + " @" + CStr(nVideoFrameRate) + " FPS , " + CStr(nAudioChannels) + " CH x " + CStr(nAudioBitsPerSample) + " BITS x " + CStr(nAudioSampleFrequency) + " HZ , " + " VIDEO INPUT : " + strVideoInput + " , " + " AUDIO INPUT : " + strAudioInput
        
        Form1.m_cSetupControl.m_scDeviceFormatInformation2.Caption = strOutput
        
    End If
    
    If nCH = 2 Then
    
        strOutput = "CH03 INFO : " + CStr(nVideoWidth) + " x " + CStr(nVH) + strFrameType + " @" + CStr(nVideoFrameRate) + " FPS , " + CStr(nAudioChannels) + " CH x " + CStr(nAudioBitsPerSample) + " BITS x " + CStr(nAudioSampleFrequency) + " HZ , " + " VIDEO INPUT : " + strVideoInput + " , " + " AUDIO INPUT : " + strAudioInput
        
        Form1.m_cSetupControl.m_scDeviceFormatInformation3.Caption = strOutput
        
    End If
    
    If nCH = 3 Then
    
        strOutput = "CH04 INFO : " + CStr(nVideoWidth) + " x " + CStr(nVH) + strFrameType + " @" + CStr(nVideoFrameRate) + " FPS , " + CStr(nAudioChannels) + " CH x " + CStr(nAudioBitsPerSample) + " BITS x " + CStr(nAudioSampleFrequency) + " HZ , " + " VIDEO INPUT : " + strVideoInput + " , " + " AUDIO INPUT : " + strAudioInput
        
        Form1.m_cSetupControl.m_scDeviceFormatInformation4.Caption = strOutput
        
    End If

    
    on_process_format_changed = QCAP_RT_OK
    
End Function


' PREVIEW VIDEO CALLBACK FUNCTION
'
Public Function on_process_preview_video_buffer(ByVal pDevice As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum

    Dim nCH As Long

    nCH = pUserData
       
    Dim iResult As Long
    
    If Form1.m_bIsShareRecord = True Then
        
        If nCH = 0 And Form1.m_bShareRecordCH1 = True Then
             
             iResult = QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YV12, Form1.m_nVideoWidth, Form1.m_nVideoHeight, pFrameBuffer, nFrameBufferLen)
            
        End If
        
        If nCH = 1 And Form1.m_bShareRecordCH2 = True Then
        
             iResult = QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YV12, Form1.m_nVideoWidth, Form1.m_nVideoHeight, pFrameBuffer, nFrameBufferLen)
            
        End If
        
        If nCH = 2 And Form1.m_bShareRecordCH3 = True Then
        
             iResult = QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YV12, Form1.m_nVideoWidth, Form1.m_nVideoHeight, pFrameBuffer, nFrameBufferLen)
        
        End If
        
        If nCH = 3 And Form1.m_bShareRecordCH4 = True Then
        
             iResult = QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YV12, Form1.m_nVideoWidth, Form1.m_nVideoHeight, pFrameBuffer, nFrameBufferLen)
        
        End If
        
    End If
    
    If Form1.m_bIsStreaming = True And Form1.m_hRtspCapDev <> 0 Then
    
        iResult = QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(Form1.m_hRtspCapDev, nCH, ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YV12, Form1.m_nVideoWidth, Form1.m_nVideoHeight, pFrameBuffer, nFrameBufferLen)
        
    End If
    
    on_process_preview_video_buffer = QCAP_RT_OK
    
End Function


' PREVIEW AUDIO CALLBACK FUNCTION
'
Public Function on_process_preview_audio_buffer(ByVal pDevice As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum

    Dim nCH As Long

    nCH = pUserData
    
    Dim iResult As ResultOfFunction
    
    If Form1.m_bIsShareRecord = True Then
    
        If nCH = 0 And Form1.m_bShareRecordCH1 = True Then

            iResult = QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, pFrameBuffer, nFrameBufferLen)
            
        End If
        
        If nCH = 1 And Form1.m_bShareRecordCH2 = True Then
        
            iResult = QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, pFrameBuffer, nFrameBufferLen)
            
        End If
        
        If nCH = 2 And Form1.m_bShareRecordCH3 = True Then
        
            iResult = QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, pFrameBuffer, nFrameBufferLen)
            
        End If
        
        If nCH = 3 And Form1.m_bShareRecordCH4 = True Then
        
            iResult = QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, pFrameBuffer, nFrameBufferLen)
        
        End If
        
    End If
    
    If Form1.m_bIsStreaming = True And Form1.m_hRtspCapDev <> 0 Then
    
        iResult = QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(Form1.m_hRtspCapDev, nCH, pFrameBuffer, nFrameBufferLen)
        
    End If
    
    on_process_preview_audio_buffer = QCAP_RT_OK
    
End Function


' VIDEO HARDWARE ENCODER CALLBACK FUNCTION
'
Public Function on_process_hardware_encoder_video_buffer(ByVal pDevice As Long, ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal bIsKeyFrame As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum
    
    on_process_hardware_encoder_video_buffer = QCAP_RT_OK
    
End Function


' NO SIGNAL DETEACTED CALLBACK FUNCTION
'
Public Function on_process_no_signal_detected(ByVal pDevice As Long, ByVal nVideoInput As Long, ByVal nAudioInput As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum

    Dim nCH As Long

    nCH = pUserData
    
    Dim cMessage As String
    
    cMessage = "CH" + CStr(nCH + 1) + " No Signal Detected"
    
    If nCH = 0 Then
    
        Form1.m_bNoSignal1 = True
        
        Form1.m_cSetupControl.m_scDeviceFormatInformation1.Caption = cMessage
    
    End If
    
    If nCH = 1 Then
    
        Form1.m_bNoSignal2 = True
        
        Form1.m_cSetupControl.m_scDeviceFormatInformation2.Caption = cMessage
    
    End If
    
    If nCH = 2 Then
    
        Form1.m_bNoSignal3 = True
        
        Form1.m_cSetupControl.m_scDeviceFormatInformation3.Caption = cMessage
    
    End If
    
    If nCH = 3 Then
    
        Form1.m_bNoSignal4 = True
        
        Form1.m_cSetupControl.m_scDeviceFormatInformation4.Caption = cMessage
    
    End If

    on_process_no_signal_detected = QCAP_RT_OK
    
End Function


' SIGNAL REMOVED CALLBACK FUNCTION
'
Public Function on_process_signal_removed(ByVal pDevice As Long, ByVal nVideoInput As Long, ByVal nAudioInput As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum

    Dim nCH As Long

    nCH = pUserData
    
    Dim cMessage As String
    
    cMessage = "CH" + CStr(nCH + 1) + " Signal Removed"
    
    If nCH = 0 Then
    
        Form1.m_bNoSignal1 = True
        
        Form1.m_cSetupControl.m_scDeviceFormatInformation1.Caption = cMessage
    
    End If
    
    If nCH = 1 Then
    
        Form1.m_bNoSignal2 = True
    
        Form1.m_cSetupControl.m_scDeviceFormatInformation2.Caption = cMessage
        
    End If
    
    If nCH = 2 Then
    
        Form1.m_bNoSignal3 = True
    
        Form1.m_cSetupControl.m_scDeviceFormatInformation3.Caption = cMessage
        
    End If
    
    If nCH = 3 Then
    
        Form1.m_bNoSignal4 = True
        
        Form1.m_cSetupControl.m_scDeviceFormatInformation4.Caption = cMessage
    
    End If

    on_process_signal_removed = QCAP_RT_OK
    
End Function


' Bitwise Right Shift Function
'
Public Function shr(ByVal Value As Long, ByVal Shift As Byte) As Long

    Dim i As Byte
    
    shr = Value
    
    If Shift > 0 Then
        shr = Int(shr / (2 ^ Shift))
    End If
    
End Function

' Bitwise Left Shift Function
'
Public Function shl(ByVal Value As Long, ByVal Shift As Byte) As Long

    shl = Value
    
    If Shift > 0 Then
    
        Dim i As Byte
        
        Dim m As Long
        
        For i = 1 To Shift
        
            m = shl And &H40000000
            
            shl = (shl And &H3FFFFFFF) * 2
            
            If m <> 0 Then
            
                shl = shl Or &H80000000
                
            End If
            
        Next i
        
    End If
    
End Function


' FOURCC
'
Private Function MAKEFOURCC(ByVal ch0 As Long, ByVal ch1 As Long, ByVal ch2 As Long, ByVal ch3 As Long) As Long
    
    MAKEFOURCC = (ch0 Or (shl(ch1, 8)) Or (shl(ch2, 16)) Or (shl(ch3, 24)))

End Function











