// FilePlayerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FilePlayer.h"
#include "FilePlayerDlg.h"
#include <iostream>
#include <fstream>
using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFilePlayerDlg dialog

CFilePlayerDlg::CFilePlayerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFilePlayerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFilePlayerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CFilePlayerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFilePlayerDlg)
	DDX_Control(pDX, IDC_PROGRESS_TIME, m_progTimeBar);
	DDX_Control(pDX, IDC_STATIC_WINDOW, m_statWindow);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH, m_editFilePath);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFilePlayerDlg, CDialog)
	//{{AFX_MSG_MAP(CFilePlayerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_OPEN, OnButtonOpen)
	ON_BN_CLICKED(IDC_BUTTON_PLAY, OnButtonPlay)
	ON_BN_CLICKED(IDC_BUTTON_PAUSE, OnButtonPause)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	ON_BN_CLICKED(IDC_BUTTON_SPEED_PLUS, OnButtonSpeedPlus)
	ON_BN_CLICKED(IDC_BUTTON_SPEED_MINUS, OnButtonSpeedMinus)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_ANALYSIS, OnButtonAnalysis)
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT, OnButtonSnapshot)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////

// CFilePlayerDlg message handlers

extern CFilePlayerApp theApp;

QRETURN on_video_decoder_file_callback( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
//	SC_DEBUG( "on_video_decoder_file_callback( %f, %d )", dSampleTime, nFrameBufferLen );

	return QCAP_RT_OK;
}

QRETURN on_audio_decoder_file_callback( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
//	SC_DEBUG( "on_audio_decoder_file_callback( %f, %d )", dSampleTime, nFrameBufferLen );

	return QCAP_RT_OK;
}

QRETURN on_snapshot_done_callback( PVOID pFile, CHAR * pszFilePathName, PVOID pUserData )
{
	SC_DEBUG( "on_snapshot_done_callback( %s )", pszFilePathName );

	return QCAP_RT_OK;
}

BOOL CFilePlayerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	// INITIALIZE COM LIBRARY
	// 
	HRESULT hr = CoInitialize( NULL );

//	m_editFilePath.SetWindowText( theApp.GetProfileString( "DEFAULT", "FILE.PATH", "" ) );	

	m_editFilePath.SetWindowText( "" );	

	m_pFile = NULL;

	m_nVideoFormat = 0;

	m_nVideoWidth = 0;

	m_nVideoHeight = 0;

	m_dVideoFrameRate = 0;

	m_nAudioFormat = 0;

	m_nAudioChannels = 0;

	m_nAudioBitsPerSample = 0;

	m_nAudioSampleFrequency = 0;

	m_dFileTotalDuationTimes = 0;

	m_nFileTotalVideoFrames = 0;

	m_nFileTotalAudioFrames = 0;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFilePlayerDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	if( m_pFile ) {

		QCAP_DESTROY_FILE( m_pFile );

		m_pFile = NULL;
	}
	CString strFilePath;

	m_editFilePath.GetWindowText( strFilePath );

	m_progTimeBar.SetRange( 0, 200 );

//	theApp.WriteProfileString( "DEFAULT", "FILE.PATH", (LPCTSTR)(strFilePath) );

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

void CFilePlayerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFilePlayerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFilePlayerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CFilePlayerDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CFilePlayerDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}


void CFilePlayerDlg::OnButtonOpen() 
{
	// TODO: Add your control notification handler code here
	
	// TODO: Add your control notification handler code here

	// SELECT THE ACTION SCRIPT FILE
	//
	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "MP4, AVI\0*.MP4;*.AVI\0";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	if( strlen( psz ) > 0 ) {

		m_strFilePath = psz;

		if( m_pFile ) {

			QCAP_DESTROY_FILE( m_pFile );

			m_pFile = NULL;
		}
		QCAP_OPEN_FILE( psz, &m_pFile, QCAP_DECODER_TYPE_SOFTWARE, &m_nVideoFormat, &m_nVideoWidth, &m_nVideoHeight, &m_dVideoFrameRate, &m_nAudioFormat, &m_nAudioChannels, &m_nAudioBitsPerSample, &m_nAudioSampleFrequency, &m_dFileTotalDuationTimes, &m_nFileTotalVideoFrames, &m_nFileTotalAudioFrames, m_statWindow.m_hWnd );

		QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK( m_pFile, on_video_decoder_file_callback, this );

		QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK( m_pFile, on_audio_decoder_file_callback, this );

		QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK( m_pFile, on_snapshot_done_callback, this );

		QCAP_PAUSE_FILE( m_pFile );

		double speed = 0;

		QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );

		CHAR psz_info[ 512 ];

		CString vfmt;

		CString afmt;

		if( m_nVideoFormat == QCAP_ENCODER_FORMAT_H264 ) { vfmt = "H264"; }

		if( m_nAudioFormat == QCAP_ENCODER_FORMAT_PCM ) { afmt = "PCM"; }

		if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_RAW ) { afmt = "AAC RAW"; }

		if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_ADTS ) { afmt = "AAC ADTS"; }

		sprintf( psz_info, "File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\nPlayback Speed = %f", m_strFilePath, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, speed );

		m_editFilePath.SetWindowText( psz_info );

		SetTimer( 0x00000000, 10, NULL );
	}
	else {

		return ;
	}
}

void CFilePlayerDlg::OnButtonPlay() 
{
	// TODO: Add your control notification handler code here

	double dSampleTime = 0;

	QCAP_GET_FILE_POSITION( m_pFile, &dSampleTime );

	if( dSampleTime >= m_dFileTotalDuationTimes ) {

		QCAP_STOP_FILE( m_pFile );
	}
	QCAP_PLAY_FILE( m_pFile );
}

void CFilePlayerDlg::OnButtonPause() 
{
	// TODO: Add your control notification handler code here

	QCAP_PAUSE_FILE( m_pFile );
}

void CFilePlayerDlg::OnButtonStop() 
{
	// TODO: Add your control notification handler code here

	QCAP_STOP_FILE( m_pFile );
}

void CFilePlayerDlg::OnButtonSpeedPlus() 
{
	// TODO: Add your control notification handler code here
	
	double speed = 0;

	QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );
	
	speed += 0.25;

	QCAP_SET_FILE_PLAYBACK_SPEED( m_pFile,  speed );

	QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );

	CHAR psz_info[ 512 ];

	CString vfmt;

	CString afmt;

	if( m_nVideoFormat == QCAP_ENCODER_FORMAT_H264 ) { vfmt = "H264"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_PCM ) { afmt = "PCM"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_RAW ) { afmt = "AAC RAW"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_ADTS ) { afmt = "AAC ADTS"; }

	sprintf( psz_info, "File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\nPlayback Speed = %f", m_strFilePath, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, speed );

	m_editFilePath.SetWindowText( psz_info );	
}

void CFilePlayerDlg::OnButtonSpeedMinus() 
{
	// TODO: Add your control notification handler code here
	
	double speed = 0;

	QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );
	
	speed -= 0.25;

	QCAP_SET_FILE_PLAYBACK_SPEED( m_pFile,  speed );

	QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );

	CHAR psz_info[ 512 ];

	CString vfmt;

	CString afmt;

	if( m_nVideoFormat == QCAP_ENCODER_FORMAT_H264 ) { vfmt = "H264"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_PCM ) { afmt = "PCM"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_RAW ) { afmt = "AAC RAW"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_ADTS ) { afmt = "AAC ADTS"; }

	sprintf( psz_info, "File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\nPlayback Speed = %f", m_strFilePath, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, speed );

	m_editFilePath.SetWindowText( psz_info );	
}

void CFilePlayerDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000000 ) {

		double dSampleTime = 0;

		QCAP_GET_FILE_POSITION( m_pFile, &dSampleTime );

		m_progTimeBar.SetPos( (int)(100.0 * (dSampleTime / m_dFileTotalDuationTimes)) );
	}
	CDialog::OnTimer(nIDEvent);
}

void CFilePlayerDlg::OnButtonAnalysis() 
{
	// TODO: Add your control notification handler code here

	CString str_path;

	CHAR psz_info[ 512 ];

	CString vfmt;

	CString afmt;

	if( m_nVideoFormat == QCAP_ENCODER_FORMAT_H264 ) { vfmt = "H264"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_PCM ) { afmt = "PCM"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_RAW ) { afmt = "AAC RAW"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_ADTS ) { afmt = "AAC ADTS"; }

	sprintf( psz_info, "File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\n", m_strFilePath, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency );

	{	CHAR psz[ MAX_PATH ];

		GetModuleFileName( NULL, psz, MAX_PATH );

		str_path = psz;

		str_path = str_path.Left( str_path.ReverseFind('\\') + 1 );

		str_path += "ANALYSIS.LOG";
	}
	ofstream file;

	file.open( str_path );

	file << psz_info;
	
	ULONG  nStreamBufferSize = m_nVideoWidth * m_nVideoHeight * 3 / 2;

	BYTE * pStreamBuffer = (BYTE *)(malloc( nStreamBufferSize ));

	double dLastSampleTime = 0;

	file << "\r\n[VIDEO STREAM]\r\n\r\n";

	for( ULONG i = 0 ; i < m_nFileTotalVideoFrames ; i++ ) {

		ULONG  nStreamBufferLen = nStreamBufferSize;

		BOOL   bIsKeyFrame = FALSE;

		double dSampleTime = 0;

		QCAP_GET_FILE_VIDEO_STREAM_BUFFER( m_pFile, i, pStreamBuffer, &nStreamBufferLen, &bIsKeyFrame, &dSampleTime );

		sprintf( psz_info, "%08d %f (%f) - %d BYTES\t[%02X%02X%02X%02X%02X%02X%02X%02X %02X%02X%02X%02X%02X%02X%02X%02X] %s\r\n", i, dSampleTime, dSampleTime - dLastSampleTime, nStreamBufferLen, pStreamBuffer[ 0 ], pStreamBuffer[ 1 ], pStreamBuffer[ 2 ], pStreamBuffer[ 3 ], pStreamBuffer[ 4 ], pStreamBuffer[ 5 ], pStreamBuffer[ 6 ], pStreamBuffer[ 7 ], pStreamBuffer[ 8 ], pStreamBuffer[ 9 ], pStreamBuffer[ 10 ], pStreamBuffer[ 11 ], pStreamBuffer[ 12 ], pStreamBuffer[ 13 ], pStreamBuffer[ 14 ], pStreamBuffer[ 15 ], bIsKeyFrame ? "[I]" : "" );

		file << psz_info;

		dLastSampleTime = dSampleTime;
	}

	file << "\r\n[AUDIO STREAM]\r\n\r\n";

	dLastSampleTime = 0;

	for( i = 0 ; i < m_nFileTotalAudioFrames ; i++ ) {

		ULONG  nStreamBufferLen = nStreamBufferSize;

		double dSampleTime = 0;

		QCAP_GET_FILE_AUDIO_STREAM_BUFFER( m_pFile, i, pStreamBuffer, &nStreamBufferLen, &dSampleTime );

		sprintf( psz_info, "%08d %f (%f) - %d BYTES\t[%02X%02X%02X%02X%02X%02X%02X%02X %02X%02X%02X%02X%02X%02X%02X%02X]\r\n", i, dSampleTime, dSampleTime - dLastSampleTime, nStreamBufferLen, pStreamBuffer[ 0 ], pStreamBuffer[ 1 ], pStreamBuffer[ 2 ], pStreamBuffer[ 3 ], pStreamBuffer[ 4 ], pStreamBuffer[ 5 ], pStreamBuffer[ 6 ], pStreamBuffer[ 7 ], pStreamBuffer[ 8 ], pStreamBuffer[ 9 ], pStreamBuffer[ 10 ], pStreamBuffer[ 11 ], pStreamBuffer[ 12 ], pStreamBuffer[ 13 ], pStreamBuffer[ 14 ], pStreamBuffer[ 15 ] );

		file << psz_info;

		dLastSampleTime = dSampleTime;
	}
	file.close();

	if( pStreamBuffer ) {

		free( pStreamBuffer );

		pStreamBuffer = NULL;
	}

#if 0 // TEST ONLY FOR EXPORT & MERGE

	QCAP_EXPORT_FILE( m_pFile, 0, m_dFileTotalDuationTimes / 2, "D:\\FRONT.2.MP4" );

	QCAP_EXPORT_FILE( m_pFile, m_dFileTotalDuationTimes / 2, m_dFileTotalDuationTimes, "D:\\BACK.2.MP4" );

	QCAP_MERGE_FILES( "D:\\FRONT.2.MP4", "D:\\BACK.2.MP4", "D:\\MERGE.2.MP4" );

#endif

	AfxMessageBox( "PLEASE CHECK ANALYSIS.LOG" ); 
}

void CFilePlayerDlg::OnButtonSnapshot() 
{
	// TODO: Add your control notification handler code here

	QCAP_SNAPSHOT_FILE_BMP( m_pFile, "D:\\TEST.BMP"  );

//	QCAP_SNAPSHOT_FILE_JPG( m_pFile, "D:\\TEST.JPG", 100 );	
}
