// AnalogDeviceAudioGraph.cpp: implementation of the CAnalogDeviceAudioGraph class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "AnalogDeviceAudioGraph.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

VOID CAnalogDeviceAudioGraph::SC_DEBUG( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[SC310] [00000000] ";

	va_list marker;

	va_start( marker, fmt );

	StringCbPrintfA( pszDebugDumpMessage + 8, sizeof(pszDebugDumpMessage), "[%08X] ", this );

	StringCbVPrintfA( pszDebugDumpMessage + 8 + 1 + 10, sizeof(pszDebugDumpMessage), fmt, marker );

	va_end( marker );

	StringCbCatA( pszDebugDumpMessage, sizeof(pszDebugDumpMessage), "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CAnalogDeviceAudioGraph::CAnalogDeviceAudioGraph()
{
//	SC_DEBUG( "CAnalogDeviceAudioGraph::CAnalogDeviceAudioGraph()" );

	for( ULONG i = 0 ; i < 32 ; i++ ) {

		m_pCaptureSourceBaseFilters[ i ] = NULL;

		m_pSampleGrabberBaseFilters[ i ] = NULL;

		m_pAMStreamConfigs[ i ] = NULL;

		m_pSampleGrabbers[ i ] = NULL;

		m_oSampleGrabbers[ i ].SetCallback( NULL, NULL );
	}
}

CAnalogDeviceAudioGraph::~CAnalogDeviceAudioGraph()
{
//	SC_DEBUG( "CAnalogDeviceAudioGraph::~CAnalogDeviceAudioGraph()" );

	CAnalogDeviceAudioGraph::Close( FALSE );
}

BOOL CAnalogDeviceAudioGraph::Close( BOOL bDumpDebugMessage )
{
	if( bDumpDebugMessage ) { SC_DEBUG( "CAnalogDeviceAudioGraph::Close()" ); }

	if( m_pCommonMediaControl ) { if( GetState() == State_Running ) { Stop(); } }

	if( m_pCommonMediaControl ) { if( GetState() == State_Paused ) { Stop(); } }

	for( ULONG i = 0 ; i < 32 ; i++ ) {

		RELEASE( m_pAMStreamConfigs[ i ] );

		RELEASE( m_pSampleGrabbers[ i ] );

		RELEASE( m_pCaptureSourceBaseFilters[ i ] );

		RELEASE( m_pSampleGrabberBaseFilters[ i ] );

		m_oSampleGrabbers[ i ].SetCallback( NULL, NULL );
	}
	return CloseGraphBuilder( bDumpDebugMessage );
}

BOOL CAnalogDeviceAudioGraph::Create( PWSTR              pwszDevName, 
									 
									  PF_BUFFER_CALLBACK pBufferCBs[ 32 ], 
									  
									  PVOID              pUserDatas[ 32 ] )
{
	WCHAR pwszFilterNameBuffer[ 256 ];

	if( FALSE == CreateGraphBuilder() ) return FALSE; 

	for( ULONG i = 0 ; i < 32 ; i++ ) {

		// FIND/ADD CAPTURE SOURCE FILTER INTO GRAPH
		//
		StringCchPrintfW( pwszFilterNameBuffer, 256, L"%ws (#%02d)", pwszDevName, i + 1 );

		if( FALSE == FindFilter( &AM_KSCATEGORY_CAPTURE, pwszFilterNameBuffer, 0, &m_pCaptureSourceBaseFilters[ i ], pwszFilterNameBuffer, 256 ) ) return FALSE;

		if( FALSE == AddFilter( m_pCaptureSourceBaseFilters[ i ], pwszFilterNameBuffer ) ) return FALSE;

		if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface( &LOOK_DOWNSTREAM_ONLY, NULL, m_pCaptureSourceBaseFilters[ i ], IID_IAMStreamConfig, (VOID **)(&m_pAMStreamConfigs[ i ]) )) ) { 
			
			SC_DEBUG( "CAnalogDeviceAudioGraph::Create( FindInterface(IID_IAMStreamConfig) )" ); 

			AM_MEDIA_TYPE * pmt = NULL;

			if( FAILED(m_pAMStreamConfigs[ i ]->GetFormat( &pmt )) ) { 
				
				SC_DEBUG( "CAnalogDeviceAudioGraph::Create( IAMStreamConfig::GetFormat() ) ERROR!!" ); 
				
				return FALSE; 
			}
			((WAVEFORMATEX *)(pmt->pbFormat))->nChannels = (USHORT)(1);

			((WAVEFORMATEX *)(pmt->pbFormat))->wBitsPerSample = (USHORT)(16);

			((WAVEFORMATEX *)(pmt->pbFormat))->nSamplesPerSec = (ULONG)(8000);

			((WAVEFORMATEX *)(pmt->pbFormat))->nBlockAlign = (USHORT)(2 * 16 / 8);

			((WAVEFORMATEX *)(pmt->pbFormat))->nAvgBytesPerSec = (ULONG)(2 * 16 * 8000 / 8);

			if( FAILED(m_pAMStreamConfigs[ i ]->SetFormat( pmt )) ) { 
				
				SC_DEBUG( "CAnalogDeviceAudioGraph::Create( IAMStreamConfig::SetFormat() ) ERROR!!" );
				
				if( pmt ) {

					DeleteMediaType( pmt );

					pmt = NULL;
				}
				return FALSE;
			}
			if( pmt ) {

				DeleteMediaType( pmt );

				pmt = NULL;
			}
		}

		// ADD SAMPLE GRABBER FILTER INTO GRAPH
		//
		StringCchPrintfW( pwszFilterNameBuffer, 256, L"Sample Grabber (#%02d)", i + 1 );

		if( FAILED(CoCreateInstance( CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (VOID **)(&m_pSampleGrabberBaseFilters[ i ]) )) ) { SC_DEBUG( "CAnalogDeviceAudioGraph::Create( CoCreateInstance(CLSID_SampleGrabber) ) ERROR!!" ); return FALSE; }

		if( FALSE == AddFilter( m_pSampleGrabberBaseFilters[ i ], pwszFilterNameBuffer ) ) return FALSE;

		if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface( NULL, NULL, m_pSampleGrabberBaseFilters[ i ], IID_ISampleGrabber, (VOID **)(&m_pSampleGrabbers[ i ]) )) ) { 
			
			SC_DEBUG( "CAnalogDeviceAudioGraph::Create( FindInterface(IID_ISampleGrabber) )" ); 

			if( FAILED(m_pSampleGrabbers[ i ]->SetOneShot( FALSE )) ) { SC_DEBUG( "CAnalogDeviceAudioGraph::Create( ISampleGrabber::SetOneShot() ) ERROR!!" ); return FALSE; }

			if( FAILED(m_pSampleGrabbers[ i ]->SetBufferSamples( FALSE )) ) { SC_DEBUG( "CAnalogDeviceAudioGraph::Create( ISampleGrabber::SetBufferSamples() ) ERROR!!" ); return FALSE; }

			if( FAILED(m_pSampleGrabbers[ i ]->SetCallback( &m_oSampleGrabbers[ i ], 0 )) ) { SC_DEBUG( "CAnalogDeviceAudioGraph::Create( ISampleGrabber::SetCallback() ) ERROR!!" ); return FALSE; }

			m_oSampleGrabbers[ i ].SetCallback( pBufferCBs[ i ], pUserDatas[ i ] );
		}

		// CONNECT THEM
		//
		if( FALSE == ConnectFilters( m_pCaptureSourceBaseFilters[ i ], m_pSampleGrabberBaseFilters[ i ] ) ) return FALSE;
	}

	// COMPLETE
	//
	SC_DEBUG( "CAnalogDeviceAudioGraph::Create()" );

	return TRUE;
}


