// MultiplexerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Multiplexer.h"
#include "MultiplexerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID Dbg( CHAR* pszStr, ... )
{
	char szData[ MAX_PATH ] = "[SC] ";

	va_list args;

	va_start( args, pszStr );

	_vsnprintf( szData + 5, sizeof( szData ) - 1, pszStr, args );

	va_end( args );

    strcat( szData, "\n" );

	OutputDebugString( szData );
};


// GLOBAL VARIABLE
//

CHAR g_sz_dlg_title[ MAX_PATH ] = { 0 };

CRect g_rect_slipts_display[ 9 * 9 ] = { 0 };

BYTE g_n_splits_division = 2;

ULONG g_n_max_device_count = 0;

ULONG g_n_device_count = 0;

CMultiplexerDlg* g_p_main_dialog = 0;

/////////////////////////////////////////////////////////////////////////////

BOOL on_process_video_buffer( double dSampleTime, BYTE* pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) {
	
	ULONG i = (ULONG)(pUserData);

	if ( g_p_main_dialog->m_oMenuInfo[ i ].nResolutionType == 0x00 ) { CVRSDK_UPDATE_VIDEO_BUFFER(	g_p_main_dialog->m_pCustomChannelWindow[ i ], pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), 1920, 1080, TRUE /*ENABLE DEINTERLACING*/ );	}

	if ( g_p_main_dialog->m_oMenuInfo[ i ].nResolutionType == 0x01 ) { CVRSDK_UPDATE_VIDEO_BUFFER(	g_p_main_dialog->m_pCustomChannelWindow[ i ], pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), 1280, 720, TRUE /*ENABLE DEINTERLACING*/ );	}

	if ( g_p_main_dialog->m_oMenuInfo[ i ].nResolutionType == 0x02 ) { CVRSDK_UPDATE_VIDEO_BUFFER(	g_p_main_dialog->m_pCustomChannelWindow[ i ], pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), 720, 576, TRUE /*ENABLE DEINTERLACING*/ );	}

	if ( g_p_main_dialog->m_oMenuInfo[ i ].nResolutionType == 0x03 ) { CVRSDK_UPDATE_VIDEO_BUFFER(	g_p_main_dialog->m_pCustomChannelWindow[ i ], pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), 720, 480, TRUE /*ENABLE DEINTERLACING*/ );	}

	return TRUE;

}

BOOL on_process_audio_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) {
	
	ULONG i = (ULONG)(pUserData);

	return TRUE;
	
}

/////////////////////////////////////////////////////////////////////////////
// CMultiplexerDlg dialog

CMultiplexerDlg::CMultiplexerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMultiplexerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMultiplexerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDI_ICON);
}

void CMultiplexerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMultiplexerDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMultiplexerDlg, CDialog)
	//{{AFX_MSG_MAP(CMultiplexerDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_LBUTTONDOWN()
	ON_WM_SYSCOMMAND()
	ON_COMMAND(IDR_MENU_CSOURC_HDMI, OnMenuCsourcHdmi)
	ON_COMMAND(IDR_MENU_CSOURC_COMPONENTS, OnMenuCsourcComponents)
	ON_COMMAND(IDR_MENU_CSOURC_DVIA, OnMenuCsourcDvia)
	ON_COMMAND(IDR_MENU_CSOURC_DVID, OnMenuCsourcDvid)
	ON_COMMAND(IDR_MENU_CSOURC_SDI, OnMenuCsourcSdi)
	ON_COMMAND(ID_MENU_STANDARD_NTSC, OnMenuStandardNtsc)
	ON_COMMAND(IDR_MENU_STANDARD_PAL, OnMenuStandardPal)
	ON_COMMAND(IDR_MENU_RESOLUTION_1920X1080, OnMenuResolution1920x1080)
	ON_COMMAND(IDR_MENU_RESOLUTION_1280X720, OnMenuResolution1280x720)
	ON_COMMAND(IDR_MENU_RESOLUTION_720X480, OnMenuResolution720x480)
	ON_COMMAND(IDR_MENU_RESOLUTION_720X576, OnMenuResolution720x576)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMultiplexerDlg message handlers

BOOL CMultiplexerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM RESOURCE
	//
	{	HRESULT hr = CoInitialize( NULL );
	}
	// INITIALIZE USER INTERFACE RESOURCE
	//
	{		
		// AUTOMATLLY GET DEVICE COUNT
		//

		AMESDK_CAPTURE_DEVICE_ENUMERATION(	NULL, &g_n_device_count, NULL, NULL, NULL, NULL, NULL, NULL );

		if ( g_n_device_count )	{

			if ( g_n_device_count <= (2*2) ){ g_n_max_device_count = 4; g_n_splits_division = 2; }
			
			else if ( g_n_device_count <= (3*3) ) { g_n_max_device_count = 9; g_n_splits_division = 3; }
			
			else if ( g_n_device_count <= (4*4) ) { g_n_max_device_count = 16; g_n_splits_division = 4; }
			
			else if ( g_n_device_count <= (5*5) ) { g_n_max_device_count = 25; g_n_splits_division = 5; }
			
			else if ( g_n_device_count <= (6*6) ) { g_n_max_device_count = 36; g_n_splits_division = 6; }
		
		}
		else {

			g_n_max_device_count = SC_DEFAULT_MAX_CHANNEL_NUM;	

			g_n_splits_division  = SC_DEFAULT_GRID_DIVISIONS;		

		}

		// initilize device source
		for ( ULONG i = 0; i < 9 * 9; i++ )
		{
			m_hVideoDevice[ i ] = 0xFFFFFFFF;

			m_hAudioDevice[ i ] = 0xFFFFFFFF;

			m_pCustomVideoRenderer[ i ] = NULL;

			m_pCustomChannelWindow[ i ] = NULL;	
						
			m_oMenuInfo[ i ].nSourceType = 0xFF;

			m_oMenuInfo[ i ].nResolutionType = 0xFF;

			m_oMenuInfo[ i ].nStandardType = 0xFF;
		}

		m_pOverlayWindowTime = NULL;

		m_pOverlayWindow = NULL;

		m_nDisplayModeNumber = 0xFFFFFFFF;	

		m_nAudioPlayChannel = -1;

		m_nWndState = 0x00000000; // 0 = split, 1 = full screen

		m_nWndowLayoutType = 0;	  // 0 = normal type, 1 = mux 2x2 type

		m_nMainWindowNum = 0; // when main window of mux type


		//
		// create and maintain layout
		//

		SetWindowPos( NULL, 0, 0, GetSystemMetrics( SM_CXSCREEN ), GetSystemMetrics( SM_CYSCREEN ), SWP_NOMOVE );

		SetWindowPos( &CWnd::wndTop,0, 0, 0, 0, SWP_NOSIZE );

		//
		// create and initialize CControlPnael
		//

		m_oControlPanelDlg.Create( IDD_CONTROL_DIALOG, this );

		CRect oControlDlgRect; m_oControlPanelDlg.GetWindowRect( &oControlDlgRect );

		ULONG cx, cy;
		
		cx = oControlDlgRect.right - oControlDlgRect.left;

		cy = oControlDlgRect.bottom - oControlDlgRect.top;

		m_oControlPanelDlg.SetWindowPos( &CWnd::wndTop, GetSystemMetrics( SM_CXSCREEN ) / 2 - cx / 2, ( GetSystemMetrics( SM_CYSCREEN ) / 2 - cy / 2 ) + (  GetSystemMetrics( SM_CYSCREEN ) / 2 - cy / 2 ), 0, 0, SWP_NOSIZE );

		m_oControlPanelDlg.ShowWindow( TRUE );


		/////////////////////////////////////////////////////////////////////

		
		CHAR szStr[ MAX_PATH ] = { 0 };

		for ( i = 0; i < g_n_max_device_count; i++ )
		{			
			// 
			SetSplitWindowLocation( &g_rect_slipts_display[ i ], i , g_n_splits_division, GetSystemMetrics( SM_CXSCREEN ), GetSystemMetrics( SM_CYSCREEN ) );

			sprintf( szStr, "MyChannelWindow#LIVE#%02d", i + 1 );

			m_oChannelWindow_LIVE[ i ].Create(	NULL,

												szStr,

												WS_CHILD | WS_VISIBLE | WS_BORDER,

												g_rect_slipts_display[ i ],

												this,

												i + 0x00000000,

												NULL );	

			m_oChannelWindow_LIVE[ i ].ShowWindow( TRUE );
								

		}	

	
		sprintf( g_sz_dlg_title, "  Multiplexer Control Panel %s", SC_DEFAULT_SOFTWARE_VERSION );

		m_oControlPanelDlg.SetWindowText( g_sz_dlg_title );

		g_p_main_dialog = this;

		//
		// INITIALIZE DEVICE RESOURCE
		//

		HwInitialize();

 

	}
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMultiplexerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CMultiplexerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL CMultiplexerDlg::HwInitialize()
{
	//
	// create and initialize device resource
	//

	HWND wnd_video[ 9 * 9 ] = { 0 };

	HWND wnd_audio[ 9 * 9 ] = { 0 };

	PF_BUFFER_CALLBACK bcb_video[ 9 * 9 ] = { 0 };

	PF_BUFFER_CALLBACK bcb_audio[ 9 * 9 ] = { 0 };
		
	PVOID params[ 9 * 9 ] = { 0 };


	for( ULONG i = 0 ; i < g_n_max_device_count ; i++ )
	{
		wnd_video[ i ] = m_oChannelWindow_LIVE[ i ].m_hWnd;

		wnd_audio[ i ] = m_oChannelWindow_LIVE[ i ].m_hWnd;

		bcb_video[ i ] = on_process_video_buffer;

		bcb_audio[ i ] = on_process_audio_buffer;

		params[ i ] = (PVOID)(i);
	}


	//
	// according to device count
	//

	for ( i = 0; i < g_n_max_device_count; i++  )
	{

		//
		// create device handle resource
		//

		m_pCustomVideoRenderer[ i ] = CVRSDK_CREATE();

		if( m_pCustomVideoRenderer[ i ] == NULL ) { continue; }

		m_pCustomChannelWindow[ i ] = CVRSDK_INSERT_CHANNEL_WINDOW( m_pCustomVideoRenderer[ i ], wnd_video[ i ], 1920, 1080  );

		if( m_pCustomChannelWindow[ i ] == NULL ) { continue; }

		/////////////////////////////////////////////////////////////////

		m_hVideoDevice[ i ] = AMESDK_CREATE( "SA7160 PCI", i, 0, NULL, on_process_video_buffer, params[ i ] );

		if( m_hVideoDevice[ i ] & 0x80000000 ) { m_hVideoDevice[ i ] = 0xFFFFFFFF; continue; }

		m_hAudioDevice[ i ] = AMESDK_CREATE( "SA7160 PCI, Analog WaveIn", i, 0, wnd_audio[ i ], on_process_audio_buffer, params[ i ] );

		if( m_hAudioDevice[ i ] & 0x80000000 ) { m_hAudioDevice[ i ] = 0xFFFFFFFF; continue; }


		//
		// set video standard and format
		//

		ULONG n_color_space_type = MAKEFOURCC('Y', 'U', 'Y', '2');

		ULONG n_bit_count = 16;

		AMESDK_SET_STANDARD( m_hVideoDevice[ i ], 0x00000001 );  // NTSC_M	
		
		m_oMenuInfo[ i ].nStandardType = 0x00;	// NTSC_M

		AMESDK_SET_FORMAT( m_hVideoDevice[ i ], n_color_space_type, 1920, 1080, n_bit_count, 29.970 );  

		m_oMenuInfo[ i ].nResolutionType = 0x00;	// 1920x1080

		AMESDK_SET_INPUT( m_hVideoDevice[ i ], SC_DEFAULT_INPUT_SUPPORT ); 

		m_oMenuInfo[ i ].nSourceType = 0x00; // HDMI

		//
		// set audio format
		//

		AMESDK_SET_FORMAT( m_hAudioDevice[ i ], 2, 16, 48000 );
		
		AMESDK_SET_INPUT( m_hAudioDevice[ i ], 0 ); // 0 = embedded audio
		
		// set the volume of the sound card renderer
		AMESDK_SET_VOLUME( m_hAudioDevice[ i ], 0 ); // 0(Mute) ~ 100(full) 

		AMESDK_RUN( m_hVideoDevice[ i ] );

		AMESDK_RUN( m_hAudioDevice[ i ] );


	}

		///////////////////////////////////////////////////////////////////

		{	HDC hMemoryDC = NULL;

			m_pOverlayWindow = CVRSDK_CREATE_OVERLAY_BUFFER( m_pCustomChannelWindow[ 0 ], 1920, 1080 );

			if( CVRSDK_LOCK_OVERLAY_BUFFER( m_pCustomChannelWindow[ 0 ], m_pOverlayWindow, &hMemoryDC ) == TRUE ) { // STATIC OVERYLAY

				Graphics graphics( hMemoryDC );

				graphics.SetSmoothingMode( SmoothingModeAntiAlias );

				graphics.SetInterpolationMode( InterpolationModeHighQualityBicubic );


				// DRAW COOL STRING
				//
				{	FontFamily o_font_family( L"Arial" );

					wchar_t pszbuf[] = L"http://www.yuan.com.tw";

					GraphicsPath o_path;

					o_path.AddString( pszbuf, -1, &o_font_family, FontStyleRegular, 40, Point( 1200, 650 ), NULL );

					for( ULONG i = 0 ; i < 8 ; i++ )
					{
						Pen o_pen( Color( 24, 0, 128, 192 ), i + 1.0f );

						o_pen.SetLineJoin( LineJoinRound );

						graphics.DrawPath( &o_pen, &o_path );
					}

					SolidBrush o_solid_brush_white( Color( 255, 255, 255, 255 ) );

					graphics.FillPath( &o_solid_brush_white, &o_path );
				}

				CVRSDK_UNLOCK_OVERLAY_BUFFER( m_pCustomChannelWindow[ 0 ], m_pOverlayWindow, hMemoryDC );

				CVRSDK_SHOW_OVERLAY_BUFFER( m_pCustomChannelWindow[ 0 ], m_pOverlayWindow, TRUE, 240, 350 );
			}
		}

		{	SetTimer( 0x00000000, 0, NULL );
		}


	/////////////////////////////////////////////////////////////////
		
	return TRUE;
}


BOOL CMultiplexerDlg::HwUnInitialize()
{

	Dbg( "CMultiplexerDlg::HwUnInitialize()" );
	
	for ( ULONG i = 0; i < 4; i++ )
	{
		// AMESDK
		if( m_hVideoDevice[ i ] != 0xFFFFFFFF ) { AMESDK_STOP( m_hVideoDevice[ i ] ); AMESDK_DESTROY( m_hVideoDevice[ i ] ); m_hVideoDevice[ i ] = 0xFFFFFFFF; }
	
		if( m_hAudioDevice[ i ] != 0xFFFFFFFF ) { AMESDK_STOP( m_hAudioDevice[ i ] ); AMESDK_DESTROY( m_hAudioDevice[ i ] ); m_hAudioDevice[ i ] = 0xFFFFFFFF; }

		// CVRSDK
		if( m_pCustomVideoRenderer[ i ] ) { CVRSDK_DESTROY( m_pCustomVideoRenderer[ i ] ); m_pCustomVideoRenderer[ i ] = NULL; } 

	}


	return TRUE;
}


void CMultiplexerDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	//
	//  uninitialize device resourc
	//

	{	HwUnInitialize();
	}


	//
	// uninitialize user interface
	//

	for ( ULONG i = 0; i < g_n_max_device_count; i++ )
	//for ( ULONG i = 0; i < 4; i++ )
	{
		if ( m_oChannelWindow_LIVE[ i ].m_hWnd ) { m_oChannelWindow_LIVE[ i ].DestroyWindow(); }
	}

	//
	// uninitialize com resource
	//
	{	CoUninitialize();
	}	

	
}

void CMultiplexerDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnLButtonDown(nFlags, point);
	
	PostMessage( WM_NCLBUTTONDOWN, HTCAPTION, MAKELPARAM( point.x,point.y ) );

}

//
// calculate each window location
//
BOOL CMultiplexerDlg::SetSplitWindowLocation( CRect *pWindowRect /* In/out */, ULONG  nWindowNumber , ULONG nGridDivisions, ULONG nRendererWidth, ULONG nRendererHeight )
{
	CHAR szStr[ MAX_PATH ] = { 0 };

	ULONG nSplitsWidth = nRendererWidth / nGridDivisions;
			
	ULONG nSplitsHeight = nRendererHeight / nGridDivisions ; 

	ULONG nMaxChannel = nGridDivisions * nGridDivisions;


	ULONG x = nWindowNumber / nGridDivisions;

	ULONG y = nWindowNumber % nGridDivisions;

	ULONG top = nSplitsWidth * y;
				
	ULONG left = nSplitsHeight * x;

	ULONG bottom = top + nSplitsWidth;

	ULONG right = left + nSplitsHeight;			

	*pWindowRect = CRect( top, left, bottom, right );			

	return TRUE;
}


BOOL CMultiplexerDlg::OnLButtonDown_CChannelWindow( ULONG nChannelNum, UINT nFlags, CPoint point )
{
	CHAR szStr[ MAX_PATH ] = { 0 };

	CRect rect; 
	
	m_oChannelWindow_LIVE[ nChannelNum ].GetClientRect( &rect );

	m_nDisplayModeNumber = nChannelNum;

	// live
	if ( ( nChannelNum & 0x20000000 ) ==  0x00000000 )
	{
		// full to split screen
		if ( m_nWndState )		
		{

			for ( ULONG i = 0; i < g_n_max_device_count; i++ )
			{

				if ( i ==  nChannelNum )
				{

					// change main window, if mux mode is applied.
					if ( m_nWndowLayoutType == 1 )
					{
						CRect oSwapRect = NULL;


						oSwapRect = g_rect_slipts_display[ i ];

						g_rect_slipts_display[ i ] = CRect( 0 , 0 , (GetSystemMetrics( SM_CXSCREEN ) / 4) * 3 , GetSystemMetrics( SM_CYSCREEN ) );	

						g_rect_slipts_display[ m_nMainWindowNum ] = oSwapRect;	

						m_oChannelWindow_LIVE[ m_nMainWindowNum ].MoveWindow( g_rect_slipts_display[ m_nMainWindowNum ] );

						m_nMainWindowNum = (BYTE)i;								
					
					}



					m_oChannelWindow_LIVE[ i ].MoveWindow( g_rect_slipts_display[ i ] );
					

					
					AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDevice[ i ] );		
					
					AMESDK_SET_VOLUME( m_hAudioDevice[ i ], 0 );

					m_nAudioPlayChannel = -1;

					// set the caption of the dialog 					
					m_oControlPanelDlg.SetWindowText( g_sz_dlg_title );
				}
				else
				{
					m_oChannelWindow_LIVE[ i ].ShowWindow( TRUE );
				}				
			}
			
			
			m_nWndState = 0;
		}
		//  split to full screen
		else	
		{
			CRect rect( 0 , 0 , GetSystemMetrics( SM_CXSCREEN ), GetSystemMetrics( SM_CYSCREEN ) );
						
			for ( ULONG i = 0; i < g_n_max_device_count; i++ )
			{
				if ( i ==  nChannelNum )
				{					
					m_oChannelWindow_LIVE[ i ].MoveWindow( rect );					

					AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDevice[ i ] );

					AMESDK_SET_VOLUME( m_hAudioDevice[ i ], 100 );
					
					m_nAudioPlayChannel = i;

					// set the caption of the dialog 
					sprintf( szStr, "%s, Channel Number = %d, Tuen on Audio", g_sz_dlg_title, ( i + 1 ) );					
					
					m_oControlPanelDlg.SetWindowText( szStr );
				}
				else
				{
					m_oChannelWindow_LIVE[ i ].ShowWindow( FALSE );
				}
			}
			
			m_nWndState = 1;
		}		
	}

	return TRUE;
}

void CMultiplexerDlg::OnSysCommand(UINT nID, LPARAM lParam) 
{
	// TODO: Add your message handler code here and/or call default

	if ( nID == SC_RESTORE )
	{
		//::SendMessage( AfxGetMainWnd()->m_hWnd, WM_SYSCOMMAND, SC_RESTORE, 0 );	
		//m_oControlPanelDlg.SendMessage( WM_SYSCOMMAND, SC_RESTORE, 0 );	
	}	

	CDialog::OnSysCommand(nID, lParam);
}


BOOL CMultiplexerDlg::OnRButtonDown_CChannelWindow( ULONG nChannelNum, CPoint point, CWnd *pWnd)
{
	CRect rect;
	
	pWnd->GetClientRect( &rect );

	// set selected channel's ID
	m_nDisplayModeNumber = nChannelNum;	
	

	// Initialize pop menu 
	//
		
	CMenu menu_main;

	menu_main.LoadMenu( IDR_MENU_MAIN );				
		
	// top - level
	CMenu *menu_top_level = menu_main.GetSubMenu( 0 );		// order 0~n submenu			
	
	
	// set each submenu to get default item	
	//////////////////////////////////////////////////////////	

	// source
			
	menu_top_level->GetSubMenu( 0 )->CheckMenuItem( m_oMenuInfo[ nChannelNum ].nSourceType, MF_BYPOSITION | MF_CHECKED );	// checked
			
	menu_top_level->GetSubMenu( 0 )->SetDefaultItem( m_oMenuInfo[ nChannelNum ].nSourceType, TRUE ); 
			
	menu_top_level->GetSubMenu( 0 )->EnableMenuItem( m_oMenuInfo[ nChannelNum ].nSourceType, MF_BYPOSITION | MF_DISABLED | MF_GRAYED );	// diable
	

	//////////////////////////////////////////////////////////

	// change the channel of standard
		
	menu_top_level->GetSubMenu( 1 )->CheckMenuItem( m_oMenuInfo[ nChannelNum ].nStandardType, MF_BYPOSITION | MF_CHECKED );	// checked
			
	menu_top_level->GetSubMenu( 1 )->SetDefaultItem( m_oMenuInfo[ nChannelNum ].nStandardType, TRUE ); 
			
	menu_top_level->GetSubMenu( 1 )->EnableMenuItem( m_oMenuInfo[ nChannelNum ].nStandardType, MF_BYPOSITION | MF_DISABLED | MF_GRAYED );	// diable
			

	//////////////////////////////////////////////////////////
	
	// change the channel of resolution		
	

	//menu_top_level->EnableMenuItem( 2, MF_BYPOSITION | MF_DISABLED | MF_GRAYED );	// diable
	
	menu_top_level->GetSubMenu( 2 )->CheckMenuItem( m_oMenuInfo[ nChannelNum ].nResolutionType, MF_BYPOSITION | MF_CHECKED );	// checked
			
	menu_top_level->GetSubMenu( 2 )->SetDefaultItem( m_oMenuInfo[ nChannelNum ].nResolutionType, TRUE ); 
			
	menu_top_level->GetSubMenu( 2 )->EnableMenuItem( m_oMenuInfo[ nChannelNum ].nResolutionType, MF_BYPOSITION | MF_DISABLED | MF_GRAYED );	// diable
	
	// NTSC
	if ( m_oMenuInfo[ nChannelNum ].nStandardType == 0x00 ) { menu_top_level->GetSubMenu( 2 )->EnableMenuItem( 2, MF_BYPOSITION | MF_DISABLED | MF_GRAYED ); }
		
	// PAL
	if ( m_oMenuInfo[ nChannelNum ].nStandardType == 0x01 ) { menu_top_level->GetSubMenu( 2 )->EnableMenuItem( 3, MF_BYPOSITION | MF_DISABLED | MF_GRAYED ); }


	//////////////////////////////////////////////////////////		

	menu_top_level->TrackPopupMenu( TPM_LEFTBUTTON | TPM_LEFTALIGN , point.x, point.y, this );

	menu_main.DestroyMenu();  

	return TRUE;



}

BOOL CMultiplexerDlg::OnMenuItemDown_ChangeSource( ULONG nType, ULONG nChannelNum ) {

	ULONG nErrCode = 0;
	
	CHAR szStr[ MAX_PATH ] = { 0 };	
	
	nErrCode = AMESDK_SET_INPUT( m_hVideoDevice[ nChannelNum ], nType );
		

	m_oMenuInfo[ nChannelNum ].nSourceType = (BYTE)nType;	// item'th position

	// set the caption of the dialog 
	sprintf( szStr, "%s, Channel Number = %d, Input Source = %d", g_sz_dlg_title, ( nChannelNum + 1 ), nType );
			
	m_oControlPanelDlg.SetWindowText( szStr );	

	return TRUE;
	//return ( nErrCode ) ? TRUE : FALSE;
}


void CMultiplexerDlg::OnMenuCsourcHdmi()
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - HDMI" );

	BOOL b_is_success = FALSE;

	// TODO: Add your command handler code here

	b_is_success = OnMenuItemDown_ChangeSource( 0x00000000, m_nDisplayModeNumber );
	
}



void CMultiplexerDlg::OnMenuCsourcComponents() 
{

	// TODO: Add your command handler code here

	Dbg( "Trigger - Components" );

	BOOL b_is_success = FALSE;

	// TODO: Add your command handler code here

	b_is_success = OnMenuItemDown_ChangeSource( 0x00000002, m_nDisplayModeNumber );
	
}

void CMultiplexerDlg::OnMenuCsourcDvia() 
{

	// TODO: Add your command handler code here

	Dbg( "Trigger - DVI-A" );

	BOOL b_is_success = FALSE;

	// TODO: Add your command handler code here

	b_is_success = OnMenuItemDown_ChangeSource( 0x00000003, m_nDisplayModeNumber );
	
}

void CMultiplexerDlg::OnMenuCsourcDvid() 
{

	// TODO: Add your command handler code here

	Dbg( "Trigger - DVI-D" );

	BOOL b_is_success = FALSE;

	// TODO: Add your command handler code here

	b_is_success = OnMenuItemDown_ChangeSource( 0x00000001, m_nDisplayModeNumber );
 
}

void CMultiplexerDlg::OnMenuCsourcSdi() 
{

	// TODO: Add your command handler code here

	Dbg( "Trigger - SDI" );

	BOOL b_is_success = FALSE;

	// TODO: Add your command handler code here

	b_is_success = OnMenuItemDown_ChangeSource( 0x00000004, m_nDisplayModeNumber );
	
}

BOOL CMultiplexerDlg::OnMenuItemDown_ChangeStandard( ULONG nType, ULONG nChannelNum )
{

	ULONG nErrCode = 0;
	
	CHAR szStr[ MAX_PATH ] = { 0 };

	ULONG n_color_space_type = MAKEFOURCC('Y', 'U', 'Y', '2');

	ULONG n_bit_count = 16;

	nErrCode = AMESDK_SET_STANDARD( m_hVideoDevice[ nChannelNum ], nType );

	if ( nType == 0x01 ) // NTSC
	{
		if ( m_oMenuInfo[ nChannelNum ].nResolutionType == 0x00 )
		{
			AMESDK_SET_FORMAT( m_hVideoDevice[ nChannelNum ], n_color_space_type, 1920, 1080, n_bit_count, 29.970 );
			
			m_oMenuInfo[ nChannelNum ].nResolutionType = 0x00;
		}

		if ( m_oMenuInfo[ nChannelNum ].nResolutionType == 0x01 )
		{
			AMESDK_SET_FORMAT( m_hVideoDevice[ nChannelNum ], n_color_space_type, 1280, 720, n_bit_count, 29.970 );
			
			m_oMenuInfo[ nChannelNum ].nResolutionType = 0x01;
		}

		if ( m_oMenuInfo[ nChannelNum ].nResolutionType == 0x02 )
		{
			AMESDK_SET_FORMAT( m_hVideoDevice[ nChannelNum ], n_color_space_type, 720, 480, n_bit_count, 29.970 );
			
			m_oMenuInfo[ nChannelNum ].nResolutionType = 0x03;
		}

		m_oMenuInfo[ nChannelNum ].nStandardType = 0x00; 			//menu item position

	}
	
	if ( nType == 0x10 ) // PAL
	{

		if ( m_oMenuInfo[ nChannelNum ].nResolutionType == 0x00 )
		{
			AMESDK_SET_FORMAT( m_hVideoDevice[ nChannelNum ], n_color_space_type, 1920, 1080, n_bit_count, 25.000 );
			
			m_oMenuInfo[ nChannelNum ].nResolutionType = 0x00;
		}

		if ( m_oMenuInfo[ nChannelNum ].nResolutionType == 0x01 )
		{
			AMESDK_SET_FORMAT( m_hVideoDevice[ nChannelNum ], n_color_space_type, 1280, 720, n_bit_count, 25.000 );
			
			m_oMenuInfo[ nChannelNum ].nResolutionType = 0x01;
		}

		if ( m_oMenuInfo[ nChannelNum ].nResolutionType == 0x03 )
		{
			AMESDK_SET_FORMAT( m_hVideoDevice[ nChannelNum ], n_color_space_type, 720, 576, n_bit_count, 25.000 );
			
			m_oMenuInfo[ nChannelNum ].nResolutionType = 0x02;
		}

		m_oMenuInfo[ nChannelNum ].nStandardType = 0x01; 			//menu item position

	
	}
	
	// set the caption of the dialog 
	sprintf( szStr, "%s, Channel Number = %d, Input nResolutionType = %d", g_sz_dlg_title, ( nChannelNum + 1 ), nType );
			
	m_oControlPanelDlg.SetWindowText( szStr );
			

	return TRUE;
	//return ( nErrCode ) ? TRUE: FALSE;


}

void CMultiplexerDlg::OnMenuStandardNtsc() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - NTSC" );

	BOOL b_is_success = FALSE;

	// TODO: Add your command handler code here

	b_is_success = OnMenuItemDown_ChangeStandard( 0x00000001, m_nDisplayModeNumber );
	

}

void CMultiplexerDlg::OnMenuStandardPal() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - PAL" );

	BOOL b_is_success = FALSE;

	// TODO: Add your command handler code here
	b_is_success = OnMenuItemDown_ChangeStandard( 0x00000010, m_nDisplayModeNumber );
	
}

BOOL CMultiplexerDlg::OnMenuItemDown_ChangeResolution( ULONG nType, ULONG nChannelNum )
{
	ULONG nErrCode = 0;
	
	CHAR szStr[ MAX_PATH ] = { 0 };	

	ULONG n_color_space_type = MAKEFOURCC('Y', 'U', 'Y', '2');

	ULONG n_bit_count = 16;

	if ( nType == 0x00000000 )
	{	
		if ( m_oMenuInfo[ nChannelNum ].nStandardType == 0x00 )
		{
			nErrCode = AMESDK_SET_FORMAT( m_hVideoDevice[ nChannelNum ], n_color_space_type, 1920, 1080, n_bit_count, 29.970 );
		}

		if ( m_oMenuInfo[ nChannelNum ].nStandardType == 0x01 )
		{
			nErrCode = AMESDK_SET_FORMAT( m_hVideoDevice[ nChannelNum ], n_color_space_type, 1920, 1080, n_bit_count, 25.000 );
		}

		m_oMenuInfo[ nChannelNum ].nResolutionType = 0x00;
	}

	if ( nType == 0x00000001 )
	{		
		
		if ( m_oMenuInfo[ nChannelNum ].nStandardType == 0x00 )
		{
			nErrCode = AMESDK_SET_FORMAT( m_hVideoDevice[ nChannelNum ], n_color_space_type, 1280, 720, n_bit_count, 29.970 );
		}

		if ( m_oMenuInfo[ nChannelNum ].nStandardType == 0x01 )
		{
			nErrCode = AMESDK_SET_FORMAT( m_hVideoDevice[ nChannelNum ], n_color_space_type, 1280, 720, n_bit_count, 25.000 );
		}
		
	
		m_oMenuInfo[ nChannelNum ].nResolutionType = 0x01;
	}

	if ( nType == 0x00000002 )
	{				
		nErrCode = AMESDK_SET_FORMAT( m_hVideoDevice[ nChannelNum ], n_color_space_type, 720, 576, n_bit_count, 25.000 );
		
		m_oMenuInfo[ nChannelNum ].nResolutionType = 0x02;
	}

	if ( nType == 0x00000003 )
	{				
		nErrCode = AMESDK_SET_FORMAT( m_hVideoDevice[ nChannelNum ], n_color_space_type, 720, 480, n_bit_count, 29.970 );

		m_oMenuInfo[ nChannelNum ].nResolutionType = 0x03;
	
	}

		
	AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDevice[ nChannelNum ] );
		
	// set the caption of the dialog 
	sprintf( szStr, "%s, Channel Number = %d, Input nResolutionType = %d", g_sz_dlg_title, ( nChannelNum + 1 ), nType );
		
	m_oControlPanelDlg.SetWindowText( szStr );
	
	
	return TRUE;
	//return ( nErrCode ) ? TRUE: FALSE;


}

void CMultiplexerDlg::OnMenuResolution1920x1080() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - 1920*1080" );

	BOOL b_is_success = FALSE;

	// TODO: Add your command handler code here

	b_is_success = OnMenuItemDown_ChangeResolution( 0x00000000, m_nDisplayModeNumber );

}

void CMultiplexerDlg::OnMenuResolution1280x720() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - 1280*720" );

	BOOL b_is_success = FALSE;

	// TODO: Add your command handler code here

	b_is_success = OnMenuItemDown_ChangeResolution( 0x00000001, m_nDisplayModeNumber );
	
}

void CMultiplexerDlg::OnMenuResolution720x480() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - 720*480" );

	BOOL b_is_success = FALSE;

	// TODO: Add your command handler code here

	b_is_success = OnMenuItemDown_ChangeResolution( 0x00000003, m_nDisplayModeNumber );

}

void CMultiplexerDlg::OnMenuResolution720x576() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - 720*576" );

	BOOL b_is_success = FALSE;

	// TODO: Add your command handler code here

	b_is_success = OnMenuItemDown_ChangeResolution( 0x00000002, m_nDisplayModeNumber );

}

void CMultiplexerDlg::OnTimer(UINT nIDEvent) 
{
	if( nIDEvent == 0x00000000 ) {

		KillTimer( 0x00000000 );

		SetTimer( 0x00000000, 1000, NULL );

		HDC hMemoryDC = NULL;

		if( m_pOverlayWindowTime == NULL )
		{
			m_pOverlayWindowTime = CVRSDK_CREATE_OVERLAY_BUFFER( m_pCustomChannelWindow[ 0 ], 330, 60);
		}

		if( CVRSDK_LOCK_OVERLAY_BUFFER( m_pCustomChannelWindow[ 0 ], m_pOverlayWindowTime, &hMemoryDC ) == TRUE ) { // DYNAMIC OVERYLAY

			SYSTEMTIME s_system_time; GetLocalTime( &s_system_time );

			Graphics graphics( hMemoryDC );

			graphics.SetSmoothingMode( SmoothingModeHighSpeed );

			graphics.SetInterpolationMode( InterpolationModeLowQuality );

			// create a timer string
			CHAR psz[ 32 ] = { 0 };		
			
			sprintf( psz, "CH00 %02d:%02d:%02d", s_system_time.wHour, s_system_time.wMinute, s_system_time.wSecond );

			// initilize arguments
			Font font( L"Arial", 30 );

			RectF layoutRect( -10.0f, 0.0f, 300.0f, 50.0f );

			StringFormat format;

			format.SetAlignment( StringAlignmentCenter );

			SolidBrush brush( Color( 255,   255,   255,   255 ) );
			
			// draw string
			graphics.DrawString(	_bstr_t(psz),
				
									-1,

									&font,

									layoutRect,

									&format,

									&brush);


			CVRSDK_UNLOCK_OVERLAY_BUFFER( m_pCustomChannelWindow[ 0 ], m_pOverlayWindowTime, hMemoryDC );

			CVRSDK_SHOW_OVERLAY_BUFFER( m_pCustomChannelWindow[ 0 ], m_pOverlayWindowTime, TRUE, 0, 0 );
		}
	}
	CDialog::OnTimer(nIDEvent);
}

