
/*  -*- pse-c -*-
 *----------------------------------------------------------------------------
 * Filename: iegd_drv.h
 * $Revision: 1.13.2.1 $
 *----------------------------------------------------------------------------
 * Gart and DRM driver for Intel Embedded Graphics Driver
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/* Copyright 2003 - 2005 Intel Corporation. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *	Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *      Neither the name Intel Corporation nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef _IEGD_DRV_H_
#define _IEGD_DRV_H_

#define KB(x) ((x) * 1024)
#define MB(x) (KB (KB (x)))
#define GB(x) (MB (KB (x)))
#include "iegd_drm.h"
#include "igd_gart.h"

/* Define the PCI IDs below */
#define INTEL_PCI_IDS \
	{0x8086, 0x8108, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x3577, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2562, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x3582, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2572, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2582, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2592, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2772, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x27a2, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x27ae, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2972, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2982, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2992, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x29a2, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2a02, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2a12, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x29c2, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x29b2, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2a42, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2e02, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2e12, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2e22, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0x8086, 0x2e32, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0}, \
	{0, 0, 0}

/* Latest kernel remove this macro from drmP.h */
#ifndef VM_OFFSET
#define VM_OFFSET(vma) ((vma)->vm_pgoff << PAGE_SHIFT)
#endif

#ifndef DRMFILE
#define DRMFILE                         struct file *
#endif

/*
 * We check kernel version here because in kernel 2.6.23 onward some of the
 * structure definition for the drm  have been change. They have remove all the
 * typedef for the drm data structure to follow kernel coding guidelines. This
 * causing backward compatibility problem with IKM. Since only the typedef and
 * the way they handling link list are changing, to create separate file just
 * for handling this changes are redundant since implementation wise are
 * still the same.
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,23)
typedef struct drm_device drm_device_t;
typedef struct drm_file drm_file_t;
typedef struct drm_map drm_map_t;
typedef struct drm_map_list drm_map_list_t;
typedef struct drm_vma_entry drm_vma_entry_t;
typedef struct drm_ioctl_desc drm_ioctl_desc_t;

#define INSERT_VMA() \
		mutex_lock(&dev->struct_mutex); \
		vma_entry->vma = vma; \
		vma_entry->pid = current->pid; \
		list_add(&vma_entry->head, &dev->vmalist); \
		mutex_unlock(&dev->struct_mutex);

#define LIST_FOR_EACH(l, d) list_for_each((l), &(d)->maplist)

#else

#define INSERT_VMA() \
		mutex_lock(&dev->struct_mutex); \
		vma_entry->vma = vma; \
		vma_entry->next = dev->vmalist; \
		vma_entry->pid = current->pid; \
		dev->vmalist = vma_entry; \
		mutex_unlock(&dev->struct_mutex);

#define LIST_FOR_EACH(l, d) list_for_each((l), &(d)->maplist->head)

#endif /* #if LINUX_VERSION_CODE */

/* Define the prototype and interfaces for functions for the different 
 * kernel version below.
 */

/* function definition in intel_interface.c */
extern int intel_mmap_buffers(struct file *filp,struct vm_area_struct *vma);

/* function definition to get pages  this is in intel_interface*/
extern int intel_getpages( drm_device_t *dev,struct file *filp, unsigned long arg );

extern int intel_freepages(drm_device_t *dev , unsigned long arg );

extern int intel_drm_info_init( drm_device_t *dev, unsigned long arg );

extern int intel_drm_info_get( drm_device_t *dev, unsigned long arg );

extern int intel_postinit(intel_device_private_t **priv);

extern int intel_prerelease(drm_device_t *dev);

/* Functions in intel_interface_265.c used in 2.6.5 kernel and below */

extern int intel_postinit_265(drm_device_t *dev);

extern int intel_prerelease_265(drm_device_t *dev);

extern int intel_getpages_265( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg );

extern int intel_freepages_265( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg );

extern int intel_drm_info_init_265( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg );

extern int intel_drm_info_get_265( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg );

/* Functions in intel_interface_2611.c used in 2.6.11 kernel and above */

extern int intel_postinit_2611(struct drm_device *dev,unsigned long flags);

extern void intel_prerelease_2611(drm_device_t *dev,DRMFILE filp);

extern int intel_getpages_2611( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg );

extern int intel_freepages_2611( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg );

extern int intel_drm_info_init_2611( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg );

extern int intel_drm_info_get_2611( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg );

extern unsigned long intel_alloc_pages(int order, int area);

extern void intel_free_pages(unsigned long address, int order, int area);

extern int drm_plb_mmap(struct file *, struct vm_area_struct *);

extern struct vm_operations_struct iegd_plb_vm_ops_drm;
extern gart_dispatch_t *gart_id;
extern dev_private_data_t private_data;

extern irqreturn_t psb_irq_handler(DRM_IRQ_ARGS);
extern void psb_irq_preinstall(struct drm_device *dev);
extern void psb_irq_postinstall(struct drm_device *dev);
extern void psb_irq_uninstall(struct drm_device *dev);
extern int psb_init(intel_device_private_t *priv);
int intel_drm_plb_interrupts( drm_device_t *dev, void *data );
#endif

